/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobs.relational;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.Program;
import org.apache.flink.api.common.ProgramDescription;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.java.record.functions.FunctionAnnotation;
import org.apache.flink.api.java.record.functions.JoinFunction;
import org.apache.flink.api.java.record.functions.ReduceFunction;
import org.apache.flink.api.java.record.io.CsvInputFormat;
import org.apache.flink.api.java.record.io.CsvOutputFormat;
import org.apache.flink.api.java.record.operators.FileDataSink;
import org.apache.flink.api.java.record.operators.FileDataSource;
import org.apache.flink.api.java.record.operators.JoinOperator;
import org.apache.flink.api.java.record.operators.ReduceOperator;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;

public class TPCHQueryAsterix
implements Program,
ProgramDescription {
    private static final long serialVersionUID = 1L;

    public Plan getPlan(String ... args) {
        int numSubtasks = args.length > 0 ? Integer.parseInt(args[0]) : 1;
        String ordersPath = args.length > 1 ? args[1] : "";
        String customerPath = args.length > 2 ? args[2] : "";
        String output = args.length > 3 ? args[3] : "";
        FileDataSource orders = new FileDataSource((FileInputFormat)new CsvInputFormat(), ordersPath, "Orders");
        orders.setParallelism(numSubtasks);
        ((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)CsvInputFormat.configureRecordFormat((FileDataSource)orders).recordDelimiter('\n')).fieldDelimiter('|')).field(IntValue.class, 1);
        FileDataSource customers = new FileDataSource((FileInputFormat)new CsvInputFormat(), customerPath, "Customers");
        customers.setParallelism(numSubtasks);
        ((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)CsvInputFormat.configureRecordFormat((FileDataSource)customers).recordDelimiter('\n')).fieldDelimiter('|')).field(IntValue.class, 0)).field(StringValue.class, 6);
        JoinOperator joinCO = JoinOperator.builder((JoinFunction)new JoinCO(), IntValue.class, (int)0, (int)0).name("JoinCO").build();
        joinCO.setParallelism(numSubtasks);
        ReduceOperator aggCO = ReduceOperator.builder((ReduceFunction)new AggCO(), StringValue.class, (int)1).name("AggCo").build();
        aggCO.setParallelism(numSubtasks);
        FileDataSink result = new FileDataSink((FileOutputFormat)new CsvOutputFormat(), output, "Output");
        result.setParallelism(numSubtasks);
        ((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)CsvOutputFormat.configureRecordFormat((FileDataSink)result).recordDelimiter('\n')).fieldDelimiter('|')).field(IntValue.class, 0)).field(StringValue.class, 1);
        result.setInput((Operator)aggCO);
        aggCO.setInput((Operator)joinCO);
        joinCO.setFirstInput((Operator)orders);
        joinCO.setSecondInput((Operator)customers);
        return new Plan((GenericDataSinkBase)result, "TPCH Asterix");
    }

    public String getDescription() {
        return "Parameters: [numSubStasks], [orders], [customer], [output]";
    }

    @ReduceOperator.Combinable
    @FunctionAnnotation.ConstantFields(value={1})
    public static class AggCO
    extends ReduceFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final IntValue integer = new IntValue();
        private Record record = new Record();

        public void reduce(Iterator<Record> records, Collector<Record> out) throws Exception {
            int count = 0;
            while (records.hasNext()) {
                this.record = records.next();
                count += ((IntValue)this.record.getField(0, (Value)this.integer)).getValue();
            }
            this.integer.setValue(count);
            this.record.setField(0, (Value)this.integer);
            out.collect((Object)this.record);
        }

        public void combine(Iterator<Record> records, Collector<Record> out) throws Exception {
            this.reduce(records, out);
        }
    }

    @FunctionAnnotation.ConstantFieldsSecondExcept(value={0})
    public static class JoinCO
    extends JoinFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final IntValue one = new IntValue(1);

        public void join(Record order, Record cust, Collector<Record> out) throws Exception {
            cust.setField(0, (Value)this.one);
            out.collect((Object)cust);
        }
    }
}

