/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobs.kmeans;

import java.util.ArrayList;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.Program;
import org.apache.flink.api.common.ProgramDescription;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.java.record.functions.CrossFunction;
import org.apache.flink.api.java.record.functions.ReduceFunction;
import org.apache.flink.api.java.record.operators.BulkIteration;
import org.apache.flink.api.java.record.operators.CrossOperator;
import org.apache.flink.api.java.record.operators.FileDataSink;
import org.apache.flink.api.java.record.operators.FileDataSource;
import org.apache.flink.api.java.record.operators.ReduceOperator;
import org.apache.flink.client.LocalExecutor;
import org.apache.flink.test.recordJobs.kmeans.udfs.ComputeDistance;
import org.apache.flink.test.recordJobs.kmeans.udfs.FindNearestCenter;
import org.apache.flink.test.recordJobs.kmeans.udfs.PointInFormat;
import org.apache.flink.test.recordJobs.kmeans.udfs.PointOutFormat;
import org.apache.flink.test.recordJobs.kmeans.udfs.RecomputeClusterCenter;
import org.apache.flink.types.IntValue;

public class KMeansCross
implements Program,
ProgramDescription {
    private static final long serialVersionUID = 1L;

    public Plan getPlan(String ... args) {
        int numSubTasks = args.length > 0 ? Integer.parseInt(args[0]) : 1;
        String dataPointInput = args.length > 1 ? args[1] : "";
        String clusterInput = args.length > 2 ? args[2] : "";
        String output = args.length > 3 ? args[3] : "";
        int numIterations = args.length > 4 ? Integer.parseInt(args[4]) : 1;
        FileDataSource initialClusterPoints = new FileDataSource((FileInputFormat)new PointInFormat(), clusterInput, "Centers");
        initialClusterPoints.setParallelism(1);
        BulkIteration iteration = new BulkIteration("K-Means Loop");
        iteration.setInput((Operator)initialClusterPoints);
        iteration.setMaximumNumberOfIterations(numIterations);
        FileDataSource dataPoints = new FileDataSource((FileInputFormat)new PointInFormat(), dataPointInput, "Data Points");
        CrossOperator computeDistance = CrossOperator.builder((CrossFunction)new ComputeDistance()).input1((Operator)dataPoints).input2(iteration.getPartialSolution()).name("Compute Distances").build();
        ReduceOperator findNearestClusterCenters = ReduceOperator.builder((ReduceFunction)new FindNearestCenter(), IntValue.class, (int)0).input((Operator)computeDistance).name("Find Nearest Centers").build();
        ReduceOperator recomputeClusterCenter = ReduceOperator.builder((ReduceFunction)new RecomputeClusterCenter(), IntValue.class, (int)0).input((Operator)findNearestClusterCenters).name("Recompute Center Positions").build();
        iteration.setNextPartialSolution((Operator)recomputeClusterCenter);
        FileDataSource dataPoints2 = new FileDataSource((FileInputFormat)new PointInFormat(), dataPointInput, "Data Points 2");
        CrossOperator computeFinalDistance = CrossOperator.builder((CrossFunction)new ComputeDistance()).input1((Operator)dataPoints2).input2((Operator)iteration).name("Compute Final Distances").build();
        ReduceOperator findNearestFinalCluster = ReduceOperator.builder((ReduceFunction)new FindNearestCenter(), IntValue.class, (int)0).input((Operator)computeFinalDistance).name("Find Nearest Final Centers").build();
        FileDataSink finalClusters = new FileDataSink((FileOutputFormat)new PointOutFormat(), output + "/centers", (Operator)iteration, "Cluster Positions");
        FileDataSink clusterAssignments = new FileDataSink((FileOutputFormat)new PointOutFormat(), output + "/points", (Operator)findNearestFinalCluster, "Cluster Assignments");
        ArrayList<FileDataSink> sinks = new ArrayList<FileDataSink>();
        sinks.add(finalClusters);
        sinks.add(clusterAssignments);
        Plan plan = new Plan(sinks, "Iterative KMeans");
        plan.setDefaultParallelism(numSubTasks);
        return plan;
    }

    public String getDescription() {
        return "Parameters: <numSubStasks> <dataPoints> <clusterCenters> <output> <numIterations>";
    }

    public static void main(String[] args) throws Exception {
        KMeansCross kmi = new KMeansCross();
        if (args.length < 5) {
            System.err.println(kmi.getDescription());
            System.exit(1);
        }
        Plan plan = kmi.getPlan(args);
        LocalExecutor.execute((Plan)plan);
    }
}

