/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobs.graph;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.Program;
import org.apache.flink.api.common.ProgramDescription;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.java.record.functions.FunctionAnnotation;
import org.apache.flink.api.java.record.functions.JoinFunction;
import org.apache.flink.api.java.record.functions.ReduceFunction;
import org.apache.flink.api.java.record.operators.BulkIteration;
import org.apache.flink.api.java.record.operators.FileDataSink;
import org.apache.flink.api.java.record.operators.FileDataSource;
import org.apache.flink.api.java.record.operators.JoinOperator;
import org.apache.flink.api.java.record.operators.ReduceOperator;
import org.apache.flink.test.recordJobs.graph.pageRankUtil.DanglingPageRankInputFormat;
import org.apache.flink.test.recordJobs.graph.pageRankUtil.ImprovedAdjacencyListInputFormat;
import org.apache.flink.test.recordJobs.graph.pageRankUtil.LongArrayView;
import org.apache.flink.test.recordJobs.graph.pageRankUtil.PageWithRankOutFormat;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;

public class SimplePageRank
implements Program,
ProgramDescription {
    private static final long serialVersionUID = 1L;
    private static final String NUM_VERTICES_CONFIG_PARAM = "pageRank.numVertices";

    public Plan getPlan(String ... args) {
        int parallelism = 1;
        String pageWithRankInputPath = "";
        String adjacencyListInputPath = "";
        String outputPath = "";
        int numIterations = 25;
        long numVertices = 5L;
        if (args.length >= 6) {
            parallelism = Integer.parseInt(args[0]);
            pageWithRankInputPath = args[1];
            adjacencyListInputPath = args[2];
            outputPath = args[3];
            numIterations = Integer.parseInt(args[4]);
            numVertices = Long.parseLong(args[5]);
        }
        FileDataSource pageWithRankInput = new FileDataSource((FileInputFormat)new DanglingPageRankInputFormat(), pageWithRankInputPath, "PageWithRank Input");
        pageWithRankInput.getParameters().setLong(NUM_VERTICES_CONFIG_PARAM, numVertices);
        BulkIteration iteration = new BulkIteration("Page Rank Loop");
        iteration.setInput((Operator)pageWithRankInput);
        FileDataSource adjacencyListInput = new FileDataSource((FileInputFormat)new ImprovedAdjacencyListInputFormat(), adjacencyListInputPath, "AdjancencyListInput");
        JoinOperator join = JoinOperator.builder((JoinFunction)new JoinVerexWithEdgesMatch(), LongValue.class, (int)0, (int)0).input1(iteration.getPartialSolution()).input2((Operator)adjacencyListInput).name("Join with Edges").build();
        ReduceOperator rankAggregation = ReduceOperator.builder((ReduceFunction)new AggregatingReduce(), LongValue.class, (int)0).input((Operator)join).name("Rank Aggregation").build();
        iteration.setNextPartialSolution((Operator)rankAggregation);
        iteration.setMaximumNumberOfIterations(numIterations);
        JoinOperator termination = JoinOperator.builder((JoinFunction)new JoinOldAndNew(), LongValue.class, (int)0, (int)0).input1(iteration.getPartialSolution()).input2((Operator)rankAggregation).name("Join Old and New").build();
        iteration.setTerminationCriterion((Operator)termination);
        FileDataSink out = new FileDataSink((FileOutputFormat)new PageWithRankOutFormat(), outputPath, (Operator)iteration, "Final Ranks");
        Plan p = new Plan((GenericDataSinkBase)out, "Simple PageRank");
        p.setDefaultParallelism(parallelism);
        return p;
    }

    public String getDescription() {
        return "Parameters: <parallelism> <pages-input-path> <edges-input-path> <output-path> <max-iterations> <num-vertices> <num-dangling-vertices>";
    }

    public static final class JoinOldAndNew
    extends JoinFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Record record = new Record();
        private LongValue vertexID = new LongValue();
        private DoubleValue newRank = new DoubleValue();
        private DoubleValue rank = new DoubleValue();

        public void join(Record pageWithRank, Record newPageWithRank, Collector<Record> out) throws Exception {
            this.rank = (DoubleValue)pageWithRank.getField(1, (Value)this.rank);
            this.newRank = (DoubleValue)newPageWithRank.getField(1, (Value)this.newRank);
            this.vertexID = (LongValue)pageWithRank.getField(0, (Value)this.vertexID);
            double epsilon = 0.05;
            double criterion = this.rank.getValue() - this.newRank.getValue();
            if (Math.abs(criterion) > epsilon) {
                this.record.setField(0, (Value)new IntValue(1));
                out.collect((Object)this.record);
            }
        }
    }

    @ReduceOperator.Combinable
    @FunctionAnnotation.ConstantFields(value={0})
    public static final class AggregatingReduce
    extends ReduceFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final DoubleValue sum = new DoubleValue();

        public void reduce(Iterator<Record> pageWithPartialRank, Collector<Record> out) throws Exception {
            Record rec = null;
            double rankSum = 0.0;
            while (pageWithPartialRank.hasNext()) {
                rec = pageWithPartialRank.next();
                rankSum += ((DoubleValue)rec.getField(1, DoubleValue.class)).getValue();
            }
            this.sum.setValue(rankSum);
            rec.setField(1, (Value)this.sum);
            out.collect((Object)rec);
        }
    }

    public static final class JoinVerexWithEdgesMatch
    extends JoinFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Record record = new Record();
        private LongValue vertexID = new LongValue();
        private DoubleValue partialRank = new DoubleValue();
        private DoubleValue rank = new DoubleValue();
        private LongArrayView adjacentNeighbors = new LongArrayView();

        public void join(Record pageWithRank, Record edges, Collector<Record> out) throws Exception {
            this.rank = (DoubleValue)pageWithRank.getField(1, (Value)this.rank);
            this.adjacentNeighbors = (LongArrayView)edges.getField(1, (Value)this.adjacentNeighbors);
            int numNeighbors = this.adjacentNeighbors.size();
            double rankToDistribute = this.rank.getValue() / (double)numNeighbors;
            this.partialRank.setValue(rankToDistribute);
            this.record.setField(1, (Value)this.partialRank);
            for (int n = 0; n < numNeighbors; ++n) {
                this.vertexID.setValue(this.adjacentNeighbors.getQuick(n));
                this.record.setField(0, (Value)this.vertexID);
                out.collect((Object)this.record);
            }
        }
    }
}

