/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobTests;

import java.util.Collection;
import org.apache.flink.api.common.Plan;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.test.recordJobs.graph.ComputeEdgeDegrees;
import org.apache.flink.test.util.RecordAPITestBase;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ComputeEdgeDegreesITCase
extends RecordAPITestBase {
    protected String edgesPath = null;
    protected String resultPath = null;
    private static final String EDGES = "1,2\n1,3\n1,4\n1,5\n2,3\n2,5\n3,4\n3,7\n4,3\n6,5\n8,3\n7,8\n5,6\n";
    private static final String EXPECTED = "1,4|2,3\n1,4|3,5\n1,4|4,2\n1,4|5,3\n2,3|3,5\n2,3|5,3\n3,5|4,2\n3,5|7,2\n5,3|6,1\n3,5|8,2\n7,2|8,2\n";

    public ComputeEdgeDegreesITCase(Configuration config) {
        super(config);
        this.setTaskManagerNumSlots(4);
    }

    protected void preSubmit() throws Exception {
        this.edgesPath = this.createTempFile("edges.txt", EDGES);
        this.resultPath = this.getTempDirPath("edgesWithDegrees");
    }

    protected Plan getTestJob() {
        ComputeEdgeDegrees computeDegrees = new ComputeEdgeDegrees();
        return computeDegrees.getPlan(String.valueOf(this.config.getInteger("NumSubtasks", 4)), this.edgesPath, this.resultPath);
    }

    protected void postSubmit() throws Exception {
        ComputeEdgeDegreesITCase.compareResultsByLinesInMemory((String)EXPECTED, (String)this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() {
        Configuration config = new Configuration();
        config.setInteger("NumSubtasks", 4);
        return ComputeEdgeDegreesITCase.toParameterList((Configuration[])new Configuration[]{config});
    }
}

