/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.operators;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.test.util.JavaProgramTestBase;
import org.apache.flink.util.Collector;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ObjectReuseITCase
extends JavaProgramTestBase {
    private static int NUM_PROGRAMS = 4;
    private int curProgId;
    private String resultPath;
    private String expectedResult;
    private static String inReducePath;
    private static String inGroupReducePath;
    private String IN_REDUCE;
    private String IN_GROUP_REDUCE;

    public ObjectReuseITCase(Configuration config) {
        super(config);
        this.curProgId = this.config.getInteger("ProgramId", -1);
        this.IN_REDUCE = "a,1\na,2\na,3\na,4\na,50\n";
        this.IN_GROUP_REDUCE = "a,1\na,2\na,3\na,4\na,5\n";
    }

    protected void preSubmit() throws Exception {
        inReducePath = this.createTempFile("in_reduce.txt", this.IN_REDUCE);
        inGroupReducePath = this.createTempFile("in_group_reduce.txt", this.IN_GROUP_REDUCE);
        this.resultPath = this.getTempDirPath("result");
    }

    protected void testProgram() throws Exception {
        this.expectedResult = Progs.runProgram(this.curProgId, this.resultPath);
    }

    protected void postSubmit() throws Exception {
        ObjectReuseITCase.compareResultsByLinesInMemory((String)this.expectedResult, (String)this.resultPath);
    }

    protected boolean skipCollectionExecution() {
        return true;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> tConfigs = new LinkedList<Configuration>();
        for (int i = 1; i <= NUM_PROGRAMS; ++i) {
            Configuration config = new Configuration();
            config.setInteger("ProgramId", i);
            tConfigs.add(config);
        }
        return ObjectReuseITCase.toParameterList(tConfigs);
    }

    private static class Progs {
        private Progs() {
        }

        public static String runProgram(int progId, String resultPath) throws Exception {
            switch (progId) {
                case 1: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    env.getConfig().enableObjectReuse();
                    Operator input = env.readCsvFile(inReducePath).types(String.class, Integer.class).setParallelism(1);
                    ReduceOperator result = input.groupBy(new int[]{0}).reduce((ReduceFunction)new ReduceFunction<Tuple2<String, Integer>>(){

                        public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) throws Exception {
                            Tuple2<String, Integer> tuple2 = value2;
                            tuple2.f1 = (Integer)tuple2.f1 + (Integer)value1.f1;
                            return value2;
                        }
                    });
                    result.writeAsCsv(resultPath);
                    env.execute();
                    return "a,100\n";
                }
                case 2: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    env.getConfig().enableObjectReuse();
                    Operator input = env.readCsvFile(inReducePath).types(String.class, Integer.class).setParallelism(1);
                    ReduceOperator result = input.reduce((ReduceFunction)new ReduceFunction<Tuple2<String, Integer>>(){

                        public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) throws Exception {
                            Tuple2<String, Integer> tuple2 = value2;
                            tuple2.f1 = (Integer)tuple2.f1 + (Integer)value1.f1;
                            return value2;
                        }
                    });
                    result.writeAsCsv(resultPath);
                    env.execute();
                    return "a,100\n";
                }
                case 3: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    env.getConfig().enableObjectReuse();
                    Operator input = env.readCsvFile(inGroupReducePath).types(String.class, Integer.class).setParallelism(1);
                    GroupReduceOperator result = input.reduceGroup((GroupReduceFunction)new GroupReduceFunction<Tuple2<String, Integer>, Tuple2<String, Integer>>(){

                        public void reduce(Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                            ArrayList<Tuple2<String, Integer>> list = new ArrayList<Tuple2<String, Integer>>();
                            for (Tuple2<String, Integer> tuple2 : values) {
                                list.add(tuple2);
                            }
                            for (Tuple2 tuple2 : list) {
                                out.collect((Object)tuple2);
                            }
                        }
                    });
                    result.writeAsCsv(resultPath);
                    env.execute();
                    return "a,4\na,4\na,5\na,5\na,5\n";
                }
                case 4: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    env.getConfig().enableObjectReuse();
                    Operator input = env.readCsvFile(inGroupReducePath).types(String.class, Integer.class).setParallelism(1);
                    GroupReduceOperator result = input.reduceGroup((GroupReduceFunction)new GroupReduceFunction<Tuple2<String, Integer>, Tuple2<String, Integer>>(){

                        public void reduce(Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                            ArrayList<Tuple2<String, Integer>> list = new ArrayList<Tuple2<String, Integer>>();
                            for (Tuple2<String, Integer> tuple2 : values) {
                                list.add(tuple2);
                            }
                            for (Tuple2 tuple2 : list) {
                                out.collect((Object)tuple2);
                            }
                        }
                    });
                    result.writeAsCsv(resultPath);
                    env.execute();
                    return "a,4\na,4\na,5\na,5\na,5\n";
                }
            }
            throw new IllegalArgumentException("Invalid program id");
        }
    }
}

