/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.operators;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.base.FileDataSourceBase;
import org.apache.flink.api.java.record.functions.CrossFunction;
import org.apache.flink.api.java.record.io.DelimitedInputFormat;
import org.apache.flink.api.java.record.operators.CrossOperator;
import org.apache.flink.api.java.record.operators.FileDataSink;
import org.apache.flink.api.java.record.operators.FileDataSource;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.test.operators.io.ContractITCaseIOFormats;
import org.apache.flink.test.util.RecordAPITestBase;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CrossITCase
extends RecordAPITestBase {
    private String leftInPath = null;
    private String rightInPath = null;
    private String resultPath = null;
    private static final String LEFT_IN = "1 1\n2 2\n3 3\n";
    private static final String RIGHT_IN = "3 6\n4 4\n4 8\n";
    private static final String RESULT = "6 6\n7 5\n7 8\n7 4\n8 3\n8 7\n8 4\n9 2\n9 6\n";

    public CrossITCase(Configuration testConfig) {
        super(testConfig);
    }

    protected void preSubmit() throws Exception {
        this.leftInPath = this.createTempFile("left_in.txt", LEFT_IN);
        this.rightInPath = this.createTempFile("right_in.txt", RIGHT_IN);
        this.resultPath = this.getTempDirPath("result");
    }

    protected Plan getTestJob() {
        FileDataSource input_left = new FileDataSource((FileInputFormat)new ContractITCaseIOFormats.ContractITCaseInputFormat(), this.leftInPath);
        DelimitedInputFormat.configureDelimitedFormat((FileDataSourceBase)input_left).recordDelimiter('\n');
        input_left.setParallelism(this.config.getInteger("CrossTest#NoSubtasks", 1));
        FileDataSource input_right = new FileDataSource((FileInputFormat)new ContractITCaseIOFormats.ContractITCaseInputFormat(), this.rightInPath);
        DelimitedInputFormat.configureDelimitedFormat((FileDataSourceBase)input_right).recordDelimiter('\n');
        input_right.setParallelism(this.config.getInteger("CrossTest#NoSubtasks", 1));
        CrossOperator testCross = CrossOperator.builder((CrossFunction)new TestCross()).build();
        testCross.setParallelism(this.config.getInteger("CrossTest#NoSubtasks", 1));
        testCross.getParameters().setString("LOCAL_STRATEGY", this.config.getString("CrossTest#LocalStrategy", ""));
        if (this.config.getString("CrossTest#ShipStrategy", "").equals("BROADCAST_FIRST")) {
            testCross.getParameters().setString("INPUT_LEFT_SHIP_STRATEGY", "SHIP_BROADCAST");
            testCross.getParameters().setString("INPUT_RIGHT_SHIP_STRATEGY", "SHIP_FORWARD");
        } else if (this.config.getString("CrossTest#ShipStrategy", "").equals("BROADCAST_SECOND")) {
            testCross.getParameters().setString("INPUT_LEFT_SHIP_STRATEGY", "SHIP_BROADCAST");
            testCross.getParameters().setString("INPUT_RIGHT_SHIP_STRATEGY", "SHIP_FORWARD");
        } else {
            testCross.getParameters().setString("INPUT_SHIP_STRATEGY", this.config.getString("CrossTest#ShipStrategy", ""));
        }
        FileDataSink output = new FileDataSink((FileOutputFormat)new ContractITCaseIOFormats.ContractITCaseOutputFormat(), this.resultPath);
        output.setParallelism(1);
        output.setInput((Operator)testCross);
        testCross.setFirstInput((Operator)input_left);
        testCross.setSecondInput((Operator)input_right);
        return new Plan((GenericDataSinkBase)output);
    }

    protected void postSubmit() throws Exception {
        CrossITCase.compareResultsByLinesInMemory((String)RESULT, (String)this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> tConfigs = new LinkedList<Configuration>();
        String[] localStrategies = new String[]{"LOCAL_STRATEGY_NESTEDLOOP_BLOCKED_OUTER_FIRST", "LOCAL_STRATEGY_NESTEDLOOP_BLOCKED_OUTER_SECOND", "LOCAL_STRATEGY_NESTEDLOOP_STREAMED_OUTER_FIRST", "LOCAL_STRATEGY_NESTEDLOOP_STREAMED_OUTER_SECOND"};
        String[] shipStrategies = new String[]{"BROADCAST_FIRST", "BROADCAST_SECOND"};
        for (String localStrategy : localStrategies) {
            for (String shipStrategy : shipStrategies) {
                Configuration config = new Configuration();
                config.setString("CrossTest#LocalStrategy", localStrategy);
                config.setString("CrossTest#ShipStrategy", shipStrategy);
                config.setInteger("CrossTest#NoSubtasks", 4);
                tConfigs.add(config);
            }
        }
        return CrossITCase.toParameterList(tConfigs);
    }

    public static class TestCross
    extends CrossFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private StringValue string = new StringValue();
        private IntValue integer = new IntValue();

        public Record cross(Record record1, Record record2) throws Exception {
            this.string = (StringValue)record1.getField(1, (Value)this.string);
            int val1 = Integer.parseInt(this.string.toString());
            this.string = (StringValue)record2.getField(1, (Value)this.string);
            int val2 = Integer.parseInt(this.string.toString());
            this.string = (StringValue)record1.getField(0, (Value)this.string);
            int key1 = Integer.parseInt(this.string.toString());
            this.string = (StringValue)record2.getField(0, (Value)this.string);
            int key2 = Integer.parseInt(this.string.toString());
            this.string.setValue((CharSequence)(key1 + key2 + 2 + ""));
            this.integer.setValue(val2 - val1 + 1);
            record1.setField(0, (Value)this.string);
            record1.setField(1, (Value)this.integer);
            return record1;
        }
    }
}

