/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.misc;

import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.test.util.ForkableFlinkMiniCluster;
import org.apache.flink.util.Collector;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MiscellaneousIssuesITCase {
    private static ForkableFlinkMiniCluster cluster;

    @BeforeClass
    public static void startCluster() {
        try {
            Configuration config = new Configuration();
            config.setInteger("localinstancemanager.numtaskmanager", 2);
            config.setInteger("taskmanager.numberOfTaskSlots", 3);
            config.setInteger("taskmanager.memory.size", 12);
            cluster = new ForkableFlinkMiniCluster(config, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to start test cluster: " + e.getMessage()));
        }
    }

    @AfterClass
    public static void shutdownCluster() {
        try {
            cluster.shutdown();
            cluster = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to stop test cluster: " + e.getMessage()));
        }
    }

    @Test
    public void testNullValues() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.createRemoteEnvironment((String)"localhost", (int)cluster.getJobManagerRPCPort(), (String[])new String[0]);
            env.setParallelism(1);
            env.getConfig().disableSysoutLogging();
            MapOperator data = env.fromElements((Object[])new String[]{"hallo"}).map((MapFunction)new MapFunction<String, String>(){

                public String map(String value) throws Exception {
                    return null;
                }
            });
            data.writeAsText("/tmp/myTest", FileSystem.WriteMode.OVERWRITE);
            try {
                env.execute();
                Assert.fail((String)"this should fail due to null values.");
            }
            catch (ProgramInvocationException e) {
                Assert.assertNotNull((Object)e.getCause());
                Assert.assertNotNull((Object)e.getCause().getCause());
                Assert.assertTrue((boolean)(e.getCause().getCause() instanceof NullPointerException));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDisjointDataflows() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.createRemoteEnvironment((String)"localhost", (int)cluster.getJobManagerRPCPort(), (String[])new String[0]);
            env.setParallelism(5);
            env.getConfig().disableSysoutLogging();
            env.generateSequence(1L, 10L).output((OutputFormat)new DiscardingOutputFormat());
            env.generateSequence(1L, 10L).output((OutputFormat)new DiscardingOutputFormat());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAccumulatorsAfterNoOp() {
        String ACC_NAME = "test_accumulator";
        try {
            ExecutionEnvironment env = ExecutionEnvironment.createRemoteEnvironment((String)"localhost", (int)cluster.getJobManagerRPCPort(), (String[])new String[0]);
            env.setParallelism(6);
            env.getConfig().disableSysoutLogging();
            env.generateSequence(1L, 1000000L).rebalance().flatMap((FlatMapFunction)new RichFlatMapFunction<Long, Long>(){
                private LongCounter counter;

                public void open(Configuration parameters) {
                    this.counter = this.getRuntimeContext().getLongCounter("test_accumulator");
                }

                public void flatMap(Long value, Collector<Long> out) {
                    this.counter.add(Long.valueOf(1L));
                }
            }).output((OutputFormat)new DiscardingOutputFormat());
            JobExecutionResult result = env.execute();
            Assert.assertEquals((Object)1000000L, result.getAllAccumulatorResults().get("test_accumulator"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

