/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.manual;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.api.common.typeutils.base.StringComparator;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeInfoParser;
import org.apache.flink.api.java.typeutils.runtime.RuntimeSerializerFactory;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memorymanager.DefaultMemoryManager;
import org.apache.flink.runtime.memorymanager.MemoryManager;
import org.apache.flink.runtime.operators.sort.UnilateralSortMerger;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.util.MutableObjectIterator;
import org.junit.Assert;

public class MassiveStringSorting {
    private static final long SEED = 347569784659278346L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringSorting() {
        File input = null;
        File sorted = null;
        try {
            input = this.generateFileWithStrings(300000, "http://some-uri.com/that/is/a/common/prefix/to/all");
            sorted = File.createTempFile("sorted_strings", "txt");
            String[] command = new String[]{"/bin/bash", "-c", "export LC_ALL=\"C\" && cat \"" + input.getAbsolutePath() + "\" | sort > \"" + sorted.getAbsolutePath() + "\""};
            Process p = null;
            try {
                p = Runtime.getRuntime().exec(command);
                int retCode = p.waitFor();
                if (retCode != 0) {
                    throw new Exception("Command failed with return code " + retCode);
                }
                p = null;
            }
            finally {
                if (p != null) {
                    p.destroy();
                }
            }
            UnilateralSortMerger sorter = null;
            BufferedReader reader = null;
            BufferedReader verifyReader = null;
            try {
                String next;
                DefaultMemoryManager mm = new DefaultMemoryManager(0x100000L, 1);
                IOManagerAsync ioMan = new IOManagerAsync();
                StringSerializer serializer = StringSerializer.INSTANCE;
                StringComparator comparator = new StringComparator(true);
                reader = new BufferedReader(new FileReader(input));
                StringReaderMutableObjectIterator inputIterator = new StringReaderMutableObjectIterator(reader);
                sorter = new UnilateralSortMerger((MemoryManager)mm, (IOManager)ioMan, (MutableObjectIterator)inputIterator, (AbstractInvokable)new DummyInvokable(), (TypeSerializerFactory)new RuntimeSerializerFactory((TypeSerializer)serializer, String.class), (TypeComparator)comparator, 1.0, 4, 0.8f);
                MutableObjectIterator sortedData = sorter.getIterator();
                reader.close();
                verifyReader = new BufferedReader(new FileReader(sorted));
                while ((next = verifyReader.readLine()) != null) {
                    String nextFromStratoSort = (String)sortedData.next((Object)"");
                    Assert.assertNotNull((Object)nextFromStratoSort);
                    Assert.assertEquals((Object)next, (Object)nextFromStratoSort);
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (verifyReader != null) {
                    verifyReader.close();
                }
                if (sorter != null) {
                    sorter.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (input != null) {
                input.delete();
            }
            if (sorted != null) {
                sorted.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringTuplesSorting() {
        int NUM_STRINGS = 300000;
        File input = null;
        File sorted = null;
        try {
            input = this.generateFileWithStringTuples(300000, "http://some-uri.com/that/is/a/common/prefix/to/all");
            sorted = File.createTempFile("sorted_strings", "txt");
            String[] command = new String[]{"/bin/bash", "-c", "export LC_ALL=\"C\" && cat \"" + input.getAbsolutePath() + "\" | sort > \"" + sorted.getAbsolutePath() + "\""};
            Process p = null;
            try {
                p = Runtime.getRuntime().exec(command);
                int retCode = p.waitFor();
                if (retCode != 0) {
                    throw new Exception("Command failed with return code " + retCode);
                }
                p = null;
            }
            finally {
                if (p != null) {
                    p.destroy();
                }
            }
            UnilateralSortMerger sorter = null;
            BufferedReader reader = null;
            BufferedReader verifyReader = null;
            try {
                DefaultMemoryManager mm = new DefaultMemoryManager(0x100000L, 1);
                IOManagerAsync ioMan = new IOManagerAsync();
                TupleTypeInfo typeInfo = (TupleTypeInfo)TypeInfoParser.parse((String)"Tuple2<String, String[]>");
                TupleSerializer serializer = typeInfo.createSerializer(new ExecutionConfig());
                TypeComparator comparator = typeInfo.createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());
                reader = new BufferedReader(new FileReader(input));
                StringTupleReaderMutableObjectIterator inputIterator = new StringTupleReaderMutableObjectIterator(reader);
                sorter = new UnilateralSortMerger((MemoryManager)mm, (IOManager)ioMan, (MutableObjectIterator)inputIterator, (AbstractInvokable)new DummyInvokable(), (TypeSerializerFactory)new RuntimeSerializerFactory((TypeSerializer)serializer, Tuple2.class), comparator, 1.0, 4, 0.8f);
                MutableObjectIterator sortedData = sorter.getIterator();
                reader.close();
                verifyReader = new BufferedReader(new FileReader(sorted));
                StringTupleReaderMutableObjectIterator verifyIterator = new StringTupleReaderMutableObjectIterator(verifyReader);
                Tuple2 next = new Tuple2((Object)"", (Object)new String[0]);
                Tuple2 nextFromStratoSort = new Tuple2((Object)"", (Object)new String[0]);
                int num = 0;
                while ((next = (Tuple2)verifyIterator.next(next)) != null) {
                    ++num;
                    nextFromStratoSort = (Tuple2)sortedData.next((Object)nextFromStratoSort);
                    Assert.assertNotNull((Object)nextFromStratoSort);
                    Assert.assertEquals((Object)next.f0, (Object)nextFromStratoSort.f0);
                    Assert.assertArrayEquals((Object[])((Object[])next.f1), (Object[])((Object[])nextFromStratoSort.f1));
                }
                Assert.assertNull((Object)sortedData.next((Object)nextFromStratoSort));
                Assert.assertEquals((long)300000L, (long)num);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (verifyReader != null) {
                    verifyReader.close();
                }
                if (sorter != null) {
                    sorter.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (input != null) {
                input.delete();
            }
            if (sorted != null) {
                sorted.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File generateFileWithStrings(int numStrings, String prefix) throws IOException {
        Random rnd = new Random(347569784659278346L);
        StringBuilder bld = new StringBuilder();
        int resetValue = prefix.length();
        bld.append(prefix);
        File f = File.createTempFile("strings", "txt");
        BufferedWriter wrt = null;
        try {
            wrt = new BufferedWriter(new FileWriter(f));
            for (int i = 0; i < numStrings; ++i) {
                bld.setLength(resetValue);
                int len = rnd.nextInt(20) + 300;
                for (int k = 0; k < len; ++k) {
                    char c = (char)(rnd.nextInt(80) + 40);
                    bld.append(c);
                }
                String str = bld.toString();
                wrt.write(str);
                wrt.newLine();
            }
        }
        finally {
            wrt.close();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File generateFileWithStringTuples(int numStrings, String prefix) throws IOException {
        Random rnd = new Random(347569784659278346L);
        StringBuilder bld = new StringBuilder();
        File f = File.createTempFile("strings", "txt");
        BufferedWriter wrt = null;
        try {
            wrt = new BufferedWriter(new FileWriter(f));
            for (int i = 0; i < numStrings; ++i) {
                bld.setLength(0);
                int numComps = rnd.nextInt(5) + 1;
                for (int z = 0; z < numComps; ++z) {
                    if (z > 0) {
                        bld.append(' ');
                    }
                    bld.append(prefix);
                    int len = rnd.nextInt(20) + 10;
                    for (int k = 0; k < len; ++k) {
                        char c = (char)(rnd.nextInt(80) + 40);
                        bld.append(c);
                    }
                }
                String str = bld.toString();
                wrt.write(str);
                wrt.newLine();
            }
        }
        finally {
            wrt.close();
        }
        return f;
    }

    public static void main(String[] args) {
        new MassiveStringSorting().testStringSorting();
        new MassiveStringSorting().testStringTuplesSorting();
    }

    private static final class StringTupleReaderMutableObjectIterator
    implements MutableObjectIterator<Tuple2<String, String[]>> {
        private final BufferedReader reader;

        public StringTupleReaderMutableObjectIterator(BufferedReader reader) {
            this.reader = reader;
        }

        public Tuple2<String, String[]> next(Tuple2<String, String[]> reuse) throws IOException {
            String line = this.reader.readLine();
            if (line == null) {
                return null;
            }
            String[] parts = line.split(" ");
            reuse.f0 = parts[0];
            reuse.f1 = parts;
            return reuse;
        }

        public Tuple2<String, String[]> next() throws IOException {
            return this.next((Tuple2<String, String[]>)new Tuple2());
        }
    }

    private static final class StringReaderMutableObjectIterator
    implements MutableObjectIterator<String> {
        private final BufferedReader reader;

        public StringReaderMutableObjectIterator(BufferedReader reader) {
            this.reader = reader;
        }

        public String next(String reuse) throws IOException {
            return this.reader.readLine();
        }

        public String next() throws IOException {
            return this.reader.readLine();
        }
    }
}

