/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.javaApiOperators;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.ProjectOperator;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.test.javaApiOperators.util.CollectionDataSets;
import org.apache.flink.test.util.JavaProgramTestBase;

public class ProjectITCase
extends JavaProgramTestBase {
    private String resultPath;
    private String expectedResult;

    protected void preSubmit() throws Exception {
        this.resultPath = this.getTempDirPath("result");
    }

    protected void testProgram() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds = CollectionDataSets.get5TupleDataSet(env);
        ProjectOperator projDs = ds.project(new int[]{3, 4, 2});
        projDs.writeAsCsv(this.resultPath);
        env.execute();
        this.expectedResult = "Hallo,1,0\nHallo Welt,2,1\nHallo Welt wie,1,2\nHallo Welt wie gehts?,2,3\nABC,2,4\nBCD,3,5\nCDE,2,6\nDEF,1,7\nEFG,1,8\nFGH,2,9\nGHI,1,10\nHIJ,3,11\nIJK,3,12\nJKL,2,13\nKLM,2,14\n";
    }

    protected void postSubmit() throws Exception {
        ProjectITCase.compareResultsByLinesInMemory((String)this.expectedResult, (String)this.resultPath);
    }
}

