/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.javaApiOperators;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.operators.ProjectOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.test.javaApiOperators.util.CollectionDataSets;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AggregateITCase
extends MultipleProgramsTestBase {
    private String resultPath;
    private String expected;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    public AggregateITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }

    @Before
    public void before() throws Exception {
        this.resultPath = this.tempFolder.newFile().toURI().toString();
    }

    @After
    public void after() throws Exception {
        AggregateITCase.compareResultsByLinesInMemory((String)this.expected, (String)this.resultPath);
    }

    @Test
    public void testFullAggregate() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        ProjectOperator aggregateDs = ds.aggregate(Aggregations.SUM, 0).and(Aggregations.MAX, 1).project(new int[]{0, 1});
        aggregateDs.writeAsCsv(this.resultPath);
        env.execute();
        this.expected = "231,6\n";
    }

    @Test
    public void testGroupedAggregate() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        ProjectOperator aggregateDs = ds.groupBy(new int[]{1}).aggregate(Aggregations.SUM, 0).project(new int[]{1, 0});
        aggregateDs.writeAsCsv(this.resultPath);
        env.execute();
        this.expected = "1,1\n2,5\n3,15\n4,34\n5,65\n6,111\n";
    }

    @Test
    public void testNestedAggregate() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        ProjectOperator aggregateDs = ds.groupBy(new int[]{1}).aggregate(Aggregations.MIN, 0).aggregate(Aggregations.MIN, 0).project(new int[]{0});
        aggregateDs.writeAsCsv(this.resultPath);
        env.execute();
        this.expected = "1\n";
    }
}

