/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative.nephele.danglingpagerank;

import org.apache.flink.api.java.record.io.DelimitedInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.test.iterative.nephele.ConfigUtils;
import org.apache.flink.test.iterative.nephele.danglingpagerank.AsciiLongArrayView;
import org.apache.flink.test.iterative.nephele.danglingpagerank.BooleanValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;

public class ImprovedDanglingPageRankInputFormat
extends DelimitedInputFormat {
    private static final long serialVersionUID = 1L;
    private LongValue vertexID = new LongValue();
    private DoubleValue initialRank;
    private BooleanValue isDangling = new BooleanValue();
    private AsciiLongArrayView arrayView = new AsciiLongArrayView();
    private static final long DANGLING_MARKER = 1L;

    public void configure(Configuration parameters) {
        long numVertices = ConfigUtils.asLong("pageRank.numVertices", parameters);
        this.initialRank = new DoubleValue(1.0 / (double)numVertices);
        super.configure(parameters);
    }

    public Record readRecord(Record target, byte[] bytes, int offset, int numBytes) {
        this.arrayView.set(bytes, offset, numBytes);
        try {
            this.arrayView.next();
            this.vertexID.setValue(this.arrayView.element());
            if (this.arrayView.next()) {
                this.isDangling.set(this.arrayView.element() == 1L);
            } else {
                this.isDangling.set(false);
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Error parsing " + this.arrayView.toString(), e);
        }
        target.clear();
        target.addField((Value)this.vertexID);
        target.addField((Value)this.initialRank);
        target.addField((Value)this.isDangling);
        return target;
    }
}

