/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative.nephele.danglingpagerank;

import org.apache.flink.api.common.aggregators.ConvergenceCriterion;
import org.apache.flink.test.iterative.nephele.danglingpagerank.PageRankStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffL1NormConvergenceCriterion
implements ConvergenceCriterion<PageRankStats> {
    private static final double EPSILON = 5.0E-5;
    private static final Logger log = LoggerFactory.getLogger(DiffL1NormConvergenceCriterion.class);

    public boolean isConverged(int iteration, PageRankStats pageRankStats) {
        double diff = pageRankStats.diff();
        if (log.isInfoEnabled()) {
            log.info("Stats in iteration [" + iteration + "]: " + pageRankStats);
            log.info("L1 norm of the vector difference is [" + diff + "] in iteration [" + iteration + "]");
        }
        return diff < 5.0E-5;
    }
}

