/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative.nephele.danglingpagerank;

import java.util.regex.Pattern;
import org.apache.flink.api.java.record.io.TextInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.test.iterative.nephele.ConfigUtils;
import org.apache.flink.test.iterative.nephele.danglingpagerank.BooleanValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;

public class DanglingPageGenerateRankInputFormat
extends TextInputFormat {
    private static final long serialVersionUID = 1L;
    private DoubleValue initialRank;
    private static final Pattern SEPARATOR = Pattern.compile("[, \t]");

    public void configure(Configuration parameters) {
        long numVertices = ConfigUtils.asLong("pageRank.numVertices", parameters);
        this.initialRank = new DoubleValue(1.0 / (double)numVertices);
        super.configure(parameters);
    }

    public Record readRecord(Record target, byte[] bytes, int offset, int numBytes) {
        String str = new String(bytes, offset, numBytes);
        String[] tokens = SEPARATOR.split(str);
        long vertexID = Long.parseLong(tokens[0]);
        boolean isDangling = tokens.length > 1 && Integer.parseInt(tokens[1]) == 1;
        target.clear();
        target.addField((Value)new LongValue(vertexID));
        target.addField((Value)this.initialRank);
        target.addField((Value)new BooleanValue(isDangling));
        return target;
    }
}

