/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative.nephele.customdanglingpagerank;

import org.apache.flink.api.common.io.DelimitedInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.test.iterative.nephele.ConfigUtils;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.types.VertexWithRankAndDangling;
import org.apache.flink.test.iterative.nephele.danglingpagerank.AsciiLongArrayView;

public class CustomImprovedDanglingPageRankInputFormat
extends DelimitedInputFormat<VertexWithRankAndDangling> {
    private static final long serialVersionUID = 1L;
    private AsciiLongArrayView arrayView = new AsciiLongArrayView();
    private static final long DANGLING_MARKER = 1L;
    private double initialRank;

    public void configure(Configuration parameters) {
        long numVertices = ConfigUtils.asLong("pageRank.numVertices", parameters);
        this.initialRank = 1.0 / (double)numVertices;
        super.configure(parameters);
    }

    public VertexWithRankAndDangling readRecord(VertexWithRankAndDangling target, byte[] bytes, int offset, int numBytes) {
        this.arrayView.set(bytes, offset, numBytes);
        try {
            this.arrayView.next();
            target.setVertexID(this.arrayView.element());
            if (this.arrayView.next()) {
                target.setDangling(this.arrayView.element() == 1L);
            } else {
                target.setDangling(false);
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Error parsing " + this.arrayView.toString(), e);
        }
        target.setRank(this.initialRank);
        return target;
    }
}

