/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative.nephele;

import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.runtime.iterative.task.IterationSynchronizationSinkTask;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.InputFormatVertex;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.OutputFormatVertex;
import org.apache.flink.runtime.operators.DataSinkTask;
import org.apache.flink.runtime.operators.DataSourceTask;
import org.apache.flink.runtime.operators.RegularPactTask;
import org.apache.flink.runtime.operators.util.TaskConfig;

public class JobGraphUtils {
    public static final long MEGABYTE = 0x100000L;

    private JobGraphUtils() {
    }

    public static <T extends FileInputFormat<?>> InputFormatVertex createInput(T stub, String path, String name, JobGraph graph, int parallelism) {
        stub.setFilePath(path);
        return JobGraphUtils.createInput(new UserCodeObjectWrapper(stub), name, graph, parallelism);
    }

    private static <T extends InputFormat<?, ?>> InputFormatVertex createInput(UserCodeWrapper<T> stub, String name, JobGraph graph, int parallelism) {
        InputFormatVertex inputVertex = new InputFormatVertex(name);
        graph.addVertex((JobVertex)inputVertex);
        inputVertex.setInvokableClass(DataSourceTask.class);
        inputVertex.setParallelism(parallelism);
        TaskConfig inputConfig = new TaskConfig(inputVertex.getConfiguration());
        inputConfig.setStubWrapper(stub);
        return inputVertex;
    }

    public static void connect(JobVertex source, JobVertex target, DistributionPattern distributionPattern) {
        target.connectNewDataSetAsInput(source, distributionPattern);
    }

    public static JobVertex createTask(Class<? extends RegularPactTask> task, String name, JobGraph graph, int parallelism) {
        JobVertex taskVertex = new JobVertex(name);
        graph.addVertex(taskVertex);
        taskVertex.setInvokableClass(task);
        taskVertex.setParallelism(parallelism);
        return taskVertex;
    }

    public static JobVertex createSync(JobGraph jobGraph, int parallelism) {
        JobVertex sync = new JobVertex("BulkIterationSync");
        jobGraph.addVertex(sync);
        sync.setInvokableClass(IterationSynchronizationSinkTask.class);
        sync.setParallelism(1);
        TaskConfig syncConfig = new TaskConfig(sync.getConfiguration());
        syncConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, parallelism);
        return sync;
    }

    public static OutputFormatVertex createFileOutput(JobGraph jobGraph, String name, int parallelism) {
        OutputFormatVertex sinkVertex = new OutputFormatVertex(name);
        jobGraph.addVertex((JobVertex)sinkVertex);
        sinkVertex.setInvokableClass(DataSinkTask.class);
        sinkVertex.setParallelism(parallelism);
        return sinkVertex;
    }
}

