/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative.nephele;

import java.io.BufferedReader;
import java.util.Collection;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.aggregators.ConvergenceCriterion;
import org.apache.flink.api.common.aggregators.LongSumAggregator;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.api.common.typeutils.record.RecordComparatorFactory;
import org.apache.flink.api.common.typeutils.record.RecordPairComparatorFactory;
import org.apache.flink.api.common.typeutils.record.RecordSerializerFactory;
import org.apache.flink.api.java.record.functions.MapFunction;
import org.apache.flink.api.java.record.io.CsvInputFormat;
import org.apache.flink.api.java.record.io.CsvOutputFormat;
import org.apache.flink.api.java.record.operators.ReduceOperator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.iterative.convergence.WorksetEmptyConvergenceCriterion;
import org.apache.flink.runtime.iterative.task.IterationHeadPactTask;
import org.apache.flink.runtime.iterative.task.IterationIntermediatePactTask;
import org.apache.flink.runtime.iterative.task.IterationTailPactTask;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.InputFormatVertex;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.OutputFormatVertex;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.operators.BuildSecondCachedMatchDriver;
import org.apache.flink.runtime.operators.CollectorMapDriver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.GroupReduceDriver;
import org.apache.flink.runtime.operators.JoinWithSolutionSetSecondDriver;
import org.apache.flink.runtime.operators.chaining.ChainedCollectorMapDriver;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.util.LocalStrategy;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.test.iterative.nephele.JobGraphUtils;
import org.apache.flink.test.recordJobs.graph.WorksetConnectedComponents;
import org.apache.flink.test.testdata.ConnectedComponentsData;
import org.apache.flink.test.util.RecordAPITestBase;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.Record;
import org.apache.flink.util.Collector;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ConnectedComponentsNepheleITCase
extends RecordAPITestBase {
    private static final long SEED = 3287269182979823L;
    private static final int NUM_VERTICES = 1000;
    private static final int NUM_EDGES = 10000;
    private static final int ITERATION_ID = 1;
    private static final long MEM_PER_CONSUMER = 3L;
    private static final int parallelism = 4;
    private static final double MEM_FRAC_PER_CONSUMER = 0.15;
    protected String verticesPath;
    protected String edgesPath;
    protected String resultPath;

    public ConnectedComponentsNepheleITCase(Configuration config) {
        super(config);
        this.setTaskManagerNumSlots(4);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() {
        Configuration config1 = new Configuration();
        config1.setInteger("testcase", 1);
        Configuration config2 = new Configuration();
        config2.setInteger("testcase", 2);
        Configuration config3 = new Configuration();
        config3.setInteger("testcase", 3);
        Configuration config4 = new Configuration();
        config4.setInteger("testcase", 4);
        return ConnectedComponentsNepheleITCase.toParameterList((Configuration[])new Configuration[]{config1, config2, config3, config4});
    }

    protected void preSubmit() throws Exception {
        this.verticesPath = this.createTempFile("vertices.txt", ConnectedComponentsData.getEnumeratingVertices((int)1000));
        this.edgesPath = this.createTempFile("edges.txt", ConnectedComponentsData.getRandomOddEvenEdges((int)10000, (int)1000, (long)3287269182979823L));
        this.resultPath = this.getTempFilePath("results");
    }

    protected JobGraph getJobGraph() throws Exception {
        int maxIterations = 100;
        int type = this.config.getInteger("testcase", 0);
        switch (type) {
            case 1: {
                return this.createJobGraphUnifiedTails(this.verticesPath, this.edgesPath, this.resultPath, 4, maxIterations);
            }
            case 2: {
                return this.createJobGraphSeparateTails(this.verticesPath, this.edgesPath, this.resultPath, 4, maxIterations);
            }
            case 3: {
                return this.createJobGraphIntermediateWorksetUpdateAndSolutionSetTail(this.verticesPath, this.edgesPath, this.resultPath, 4, maxIterations);
            }
            case 4: {
                return this.createJobGraphSolutionSetUpdateAndWorksetTail(this.verticesPath, this.edgesPath, this.resultPath, 4, maxIterations);
            }
        }
        throw new RuntimeException("Broken test configuration");
    }

    protected void postSubmit() throws Exception {
        for (BufferedReader reader : ConnectedComponentsNepheleITCase.getResultReader((String)this.resultPath)) {
            ConnectedComponentsData.checkOddEvenResult((BufferedReader)reader);
        }
    }

    private static InputFormatVertex createVerticesInput(JobGraph jobGraph, String verticesPath, int numSubTasks, TypeSerializerFactory<?> serializer, TypeComparatorFactory<?> comparator) {
        CsvInputFormat verticesInFormat = new CsvInputFormat(' ', new Class[]{LongValue.class});
        InputFormatVertex verticesInput = JobGraphUtils.createInput(verticesInFormat, verticesPath, "VerticesInput", jobGraph, numSubTasks);
        TaskConfig verticesInputConfig = new TaskConfig(verticesInput.getConfiguration());
        verticesInputConfig.addOutputShipStrategy(ShipStrategyType.FORWARD);
        verticesInputConfig.setOutputSerializer(serializer);
        TaskConfig chainedMapperConfig = new TaskConfig(new Configuration());
        chainedMapperConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(IdDuplicator.class));
        chainedMapperConfig.setDriverStrategy(DriverStrategy.COLLECTOR_MAP);
        chainedMapperConfig.setInputLocalStrategy(0, LocalStrategy.NONE);
        chainedMapperConfig.setInputSerializer(serializer, 0);
        chainedMapperConfig.setOutputSerializer(serializer);
        chainedMapperConfig.addOutputShipStrategy(ShipStrategyType.PARTITION_HASH);
        chainedMapperConfig.addOutputShipStrategy(ShipStrategyType.PARTITION_HASH);
        chainedMapperConfig.setOutputComparator(comparator, 0);
        chainedMapperConfig.setOutputComparator(comparator, 1);
        verticesInputConfig.addChainedTask(ChainedCollectorMapDriver.class, chainedMapperConfig, "ID Duplicator");
        return verticesInput;
    }

    private static InputFormatVertex createEdgesInput(JobGraph jobGraph, String edgesPath, int numSubTasks, TypeSerializerFactory<?> serializer, TypeComparatorFactory<?> comparator) {
        CsvInputFormat edgesInFormat = new CsvInputFormat(' ', new Class[]{LongValue.class, LongValue.class});
        InputFormatVertex edgesInput = JobGraphUtils.createInput(edgesInFormat, edgesPath, "EdgesInput", jobGraph, numSubTasks);
        TaskConfig edgesInputConfig = new TaskConfig(edgesInput.getConfiguration());
        edgesInputConfig.setOutputSerializer(serializer);
        edgesInputConfig.addOutputShipStrategy(ShipStrategyType.PARTITION_HASH);
        edgesInputConfig.setOutputComparator(comparator, 0);
        return edgesInput;
    }

    private static JobVertex createIterationHead(JobGraph jobGraph, int numSubTasks, TypeSerializerFactory<?> serializer, TypeComparatorFactory<?> comparator, TypePairComparatorFactory<?, ?> pairComparator) {
        JobVertex head = JobGraphUtils.createTask(IterationHeadPactTask.class, "Join With Edges (Iteration Head)", jobGraph, numSubTasks);
        TaskConfig headConfig = new TaskConfig(head.getConfiguration());
        headConfig.setIterationId(1);
        headConfig.addInputToGroup(0);
        headConfig.setInputSerializer(serializer, 0);
        headConfig.setInputComparator(comparator, 0);
        headConfig.setInputLocalStrategy(0, LocalStrategy.NONE);
        headConfig.setIterationHeadPartialSolutionOrWorksetInputIndex(0);
        headConfig.addInputToGroup(1);
        headConfig.setInputSerializer(serializer, 1);
        headConfig.setInputComparator(comparator, 1);
        headConfig.setInputLocalStrategy(1, LocalStrategy.NONE);
        headConfig.setInputCached(1, true);
        headConfig.setRelativeInputMaterializationMemory(1, 0.15);
        headConfig.addInputToGroup(2);
        headConfig.setInputSerializer(serializer, 2);
        headConfig.setInputComparator(comparator, 2);
        headConfig.setInputLocalStrategy(2, LocalStrategy.NONE);
        headConfig.setIterationHeadSolutionSetInputIndex(2);
        headConfig.setSolutionSetSerializer(serializer);
        headConfig.setSolutionSetComparator(comparator);
        headConfig.setIsWorksetIteration();
        headConfig.setRelativeBackChannelMemory(0.15);
        headConfig.setRelativeSolutionSetMemory(0.15);
        headConfig.setOutputSerializer(serializer);
        headConfig.addOutputShipStrategy(ShipStrategyType.PARTITION_HASH);
        headConfig.setOutputComparator(comparator, 0);
        TaskConfig headFinalOutConfig = new TaskConfig(new Configuration());
        headFinalOutConfig.setOutputSerializer(serializer);
        headFinalOutConfig.addOutputShipStrategy(ShipStrategyType.FORWARD);
        headConfig.setIterationHeadFinalOutputConfig(headFinalOutConfig);
        headConfig.setIterationHeadIndexOfSyncOutput(2);
        headConfig.setDriver(BuildSecondCachedMatchDriver.class);
        headConfig.setDriverStrategy(DriverStrategy.HYBRIDHASH_BUILD_SECOND);
        headConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(WorksetConnectedComponents.NeighborWithComponentIDJoin.class));
        headConfig.setDriverComparator(comparator, 0);
        headConfig.setDriverComparator(comparator, 1);
        headConfig.setDriverPairComparator(pairComparator);
        headConfig.setRelativeMemoryDriver(0.15);
        headConfig.addIterationAggregator("pact.runtime.workset-empty-aggregator", (Aggregator)new LongSumAggregator());
        return head;
    }

    private static JobVertex createIterationIntermediate(JobGraph jobGraph, int numSubTasks, TypeSerializerFactory<?> serializer, TypeComparatorFactory<?> comparator) {
        JobVertex intermediate = JobGraphUtils.createTask(IterationIntermediatePactTask.class, "Find Min Component-ID", jobGraph, numSubTasks);
        TaskConfig intermediateConfig = new TaskConfig(intermediate.getConfiguration());
        intermediateConfig.setIterationId(1);
        intermediateConfig.addInputToGroup(0);
        intermediateConfig.setInputSerializer(serializer, 0);
        intermediateConfig.setInputComparator(comparator, 0);
        intermediateConfig.setInputLocalStrategy(0, LocalStrategy.SORT);
        intermediateConfig.setRelativeMemoryInput(0, 0.15);
        intermediateConfig.setFilehandlesInput(0, 64);
        intermediateConfig.setSpillingThresholdInput(0, 0.85f);
        intermediateConfig.setOutputSerializer(serializer);
        intermediateConfig.addOutputShipStrategy(ShipStrategyType.FORWARD);
        intermediateConfig.setDriver(GroupReduceDriver.class);
        intermediateConfig.setDriverStrategy(DriverStrategy.SORTED_GROUP_REDUCE);
        intermediateConfig.setDriverComparator(comparator, 0);
        intermediateConfig.setStubWrapper((UserCodeWrapper)new UserCodeObjectWrapper((Object)new ReduceOperator.WrappingClassReduceFunction(WorksetConnectedComponents.MinimumComponentIDReduce.class)));
        return intermediate;
    }

    private static OutputFormatVertex createOutput(JobGraph jobGraph, String resultPath, int numSubTasks, TypeSerializerFactory<?> serializer) {
        OutputFormatVertex output = JobGraphUtils.createFileOutput(jobGraph, "Final Output", numSubTasks);
        TaskConfig outputConfig = new TaskConfig(output.getConfiguration());
        outputConfig.addInputToGroup(0);
        outputConfig.setInputSerializer(serializer, 0);
        outputConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(CsvOutputFormat.class));
        outputConfig.setStubParameter("flink.output.file", resultPath);
        Configuration outputUserConfig = outputConfig.getStubParameters();
        outputUserConfig.setString("output.record.delimiter", "\n");
        outputUserConfig.setString("output.record.field-delimiter", " ");
        outputUserConfig.setClass("output.record.type_0", LongValue.class);
        outputUserConfig.setInteger("output.record.position_0", 0);
        outputUserConfig.setClass("output.record.type_1", LongValue.class);
        outputUserConfig.setInteger("output.record.position_1", 1);
        outputUserConfig.setInteger("output.record.num-fields", 2);
        return output;
    }

    private static JobVertex createSync(JobGraph jobGraph, int numSubTasks, int maxIterations) {
        JobVertex sync = JobGraphUtils.createSync(jobGraph, numSubTasks);
        TaskConfig syncConfig = new TaskConfig(sync.getConfiguration());
        syncConfig.setNumberOfIterations(maxIterations);
        syncConfig.setIterationId(1);
        syncConfig.addIterationAggregator("pact.runtime.workset-empty-aggregator", (Aggregator)new LongSumAggregator());
        syncConfig.setConvergenceCriterion("pact.runtime.workset-empty-aggregator", (ConvergenceCriterion)new WorksetEmptyConvergenceCriterion());
        return sync;
    }

    public JobGraph createJobGraphUnifiedTails(String verticesPath, String edgesPath, String resultPath, int numSubTasks, int maxIterations) {
        RecordSerializerFactory serializer = RecordSerializerFactory.get();
        RecordComparatorFactory comparator = new RecordComparatorFactory(new int[]{0}, new Class[]{LongValue.class}, new boolean[]{true});
        RecordPairComparatorFactory pairComparator = RecordPairComparatorFactory.get();
        JobGraph jobGraph = new JobGraph("Connected Components (Unified Tails)");
        InputFormatVertex vertices = ConnectedComponentsNepheleITCase.createVerticesInput(jobGraph, verticesPath, numSubTasks, serializer, comparator);
        InputFormatVertex edges = ConnectedComponentsNepheleITCase.createEdgesInput(jobGraph, edgesPath, numSubTasks, serializer, comparator);
        JobVertex head = ConnectedComponentsNepheleITCase.createIterationHead(jobGraph, numSubTasks, serializer, comparator, pairComparator);
        JobVertex intermediate = ConnectedComponentsNepheleITCase.createIterationIntermediate(jobGraph, numSubTasks, serializer, comparator);
        TaskConfig intermediateConfig = new TaskConfig(intermediate.getConfiguration());
        OutputFormatVertex output = ConnectedComponentsNepheleITCase.createOutput(jobGraph, resultPath, numSubTasks, serializer);
        JobVertex sync = ConnectedComponentsNepheleITCase.createSync(jobGraph, numSubTasks, maxIterations);
        JobVertex tail = JobGraphUtils.createTask(IterationTailPactTask.class, "IterationTail", jobGraph, numSubTasks);
        TaskConfig tailConfig = new TaskConfig(tail.getConfiguration());
        tailConfig.setIterationId(1);
        tailConfig.setIsWorksetIteration();
        tailConfig.setIsWorksetUpdate();
        tailConfig.setIsSolutionSetUpdate();
        tailConfig.setIsSolutionSetUpdateWithoutReprobe();
        tailConfig.addInputToGroup(0);
        tailConfig.setInputSerializer((TypeSerializerFactory)serializer, 0);
        tailConfig.setOutputSerializer((TypeSerializerFactory)serializer);
        tailConfig.setDriver(JoinWithSolutionSetSecondDriver.class);
        tailConfig.setDriverStrategy(DriverStrategy.HYBRIDHASH_BUILD_SECOND);
        tailConfig.setDriverComparator((TypeComparatorFactory)comparator, 0);
        tailConfig.setDriverPairComparator((TypePairComparatorFactory)pairComparator);
        tailConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(WorksetConnectedComponents.UpdateComponentIdMatch.class));
        JobGraphUtils.connect((JobVertex)vertices, head, DistributionPattern.ALL_TO_ALL);
        JobGraphUtils.connect((JobVertex)edges, head, DistributionPattern.ALL_TO_ALL);
        JobGraphUtils.connect((JobVertex)vertices, head, DistributionPattern.ALL_TO_ALL);
        JobGraphUtils.connect(head, intermediate, DistributionPattern.ALL_TO_ALL);
        intermediateConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, numSubTasks);
        JobGraphUtils.connect(intermediate, tail, DistributionPattern.POINTWISE);
        tailConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, 1);
        JobGraphUtils.connect(head, (JobVertex)output, DistributionPattern.POINTWISE);
        JobGraphUtils.connect(head, sync, DistributionPattern.POINTWISE);
        SlotSharingGroup sharingGroup = new SlotSharingGroup();
        vertices.setSlotSharingGroup(sharingGroup);
        edges.setSlotSharingGroup(sharingGroup);
        head.setSlotSharingGroup(sharingGroup);
        intermediate.setSlotSharingGroup(sharingGroup);
        tail.setSlotSharingGroup(sharingGroup);
        output.setSlotSharingGroup(sharingGroup);
        sync.setSlotSharingGroup(sharingGroup);
        intermediate.setStrictlyCoLocatedWith(head);
        tail.setStrictlyCoLocatedWith(head);
        return jobGraph;
    }

    public JobGraph createJobGraphSeparateTails(String verticesPath, String edgesPath, String resultPath, int numSubTasks, int maxIterations) {
        RecordSerializerFactory serializer = RecordSerializerFactory.get();
        RecordComparatorFactory comparator = new RecordComparatorFactory(new int[]{0}, new Class[]{LongValue.class}, new boolean[]{true});
        RecordPairComparatorFactory pairComparator = RecordPairComparatorFactory.get();
        JobGraph jobGraph = new JobGraph("Connected Components (Unified Tails)");
        InputFormatVertex vertices = ConnectedComponentsNepheleITCase.createVerticesInput(jobGraph, verticesPath, numSubTasks, serializer, comparator);
        InputFormatVertex edges = ConnectedComponentsNepheleITCase.createEdgesInput(jobGraph, edgesPath, numSubTasks, serializer, comparator);
        JobVertex head = ConnectedComponentsNepheleITCase.createIterationHead(jobGraph, numSubTasks, serializer, comparator, pairComparator);
        TaskConfig headConfig = new TaskConfig(head.getConfiguration());
        headConfig.setWaitForSolutionSetUpdate();
        JobVertex intermediate = ConnectedComponentsNepheleITCase.createIterationIntermediate(jobGraph, numSubTasks, serializer, comparator);
        TaskConfig intermediateConfig = new TaskConfig(intermediate.getConfiguration());
        OutputFormatVertex output = ConnectedComponentsNepheleITCase.createOutput(jobGraph, resultPath, numSubTasks, serializer);
        JobVertex sync = ConnectedComponentsNepheleITCase.createSync(jobGraph, numSubTasks, maxIterations);
        JobVertex ssJoinIntermediate = JobGraphUtils.createTask(IterationIntermediatePactTask.class, "Solution Set Join", jobGraph, numSubTasks);
        TaskConfig ssJoinIntermediateConfig = new TaskConfig(ssJoinIntermediate.getConfiguration());
        ssJoinIntermediateConfig.setIterationId(1);
        ssJoinIntermediateConfig.addInputToGroup(0);
        ssJoinIntermediateConfig.setInputSerializer((TypeSerializerFactory)serializer, 0);
        ssJoinIntermediateConfig.addOutputShipStrategy(ShipStrategyType.FORWARD);
        ssJoinIntermediateConfig.addOutputShipStrategy(ShipStrategyType.FORWARD);
        ssJoinIntermediateConfig.setOutputComparator((TypeComparatorFactory)comparator, 0);
        ssJoinIntermediateConfig.setOutputComparator((TypeComparatorFactory)comparator, 1);
        ssJoinIntermediateConfig.setOutputSerializer((TypeSerializerFactory)serializer);
        ssJoinIntermediateConfig.setDriver(JoinWithSolutionSetSecondDriver.class);
        ssJoinIntermediateConfig.setDriverStrategy(DriverStrategy.HYBRIDHASH_BUILD_SECOND);
        ssJoinIntermediateConfig.setDriverComparator((TypeComparatorFactory)comparator, 0);
        ssJoinIntermediateConfig.setDriverPairComparator((TypePairComparatorFactory)pairComparator);
        ssJoinIntermediateConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(WorksetConnectedComponents.UpdateComponentIdMatch.class));
        JobVertex ssTail = JobGraphUtils.createTask(IterationTailPactTask.class, "IterationSolutionSetTail", jobGraph, numSubTasks);
        TaskConfig ssTailConfig = new TaskConfig(ssTail.getConfiguration());
        ssTailConfig.setIterationId(1);
        ssTailConfig.setIsSolutionSetUpdate();
        ssTailConfig.setIsWorksetIteration();
        ssTailConfig.addInputToGroup(0);
        ssTailConfig.setInputSerializer((TypeSerializerFactory)serializer, 0);
        ssTailConfig.setInputAsynchronouslyMaterialized(0, true);
        ssTailConfig.setRelativeInputMaterializationMemory(0, 0.15);
        ssTailConfig.setOutputSerializer((TypeSerializerFactory)serializer);
        ssTailConfig.setDriver(CollectorMapDriver.class);
        ssTailConfig.setDriverStrategy(DriverStrategy.COLLECTOR_MAP);
        ssTailConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(DummyMapper.class));
        JobVertex wsTail = JobGraphUtils.createTask(IterationTailPactTask.class, "IterationWorksetTail", jobGraph, numSubTasks);
        TaskConfig wsTailConfig = new TaskConfig(wsTail.getConfiguration());
        wsTailConfig.setIterationId(1);
        wsTailConfig.setIsWorksetIteration();
        wsTailConfig.setIsWorksetUpdate();
        wsTailConfig.addInputToGroup(0);
        wsTailConfig.setInputSerializer((TypeSerializerFactory)serializer, 0);
        wsTailConfig.setOutputSerializer((TypeSerializerFactory)serializer);
        wsTailConfig.setDriver(CollectorMapDriver.class);
        wsTailConfig.setDriverStrategy(DriverStrategy.COLLECTOR_MAP);
        wsTailConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(DummyMapper.class));
        JobGraphUtils.connect((JobVertex)vertices, head, DistributionPattern.ALL_TO_ALL);
        JobGraphUtils.connect((JobVertex)edges, head, DistributionPattern.ALL_TO_ALL);
        JobGraphUtils.connect((JobVertex)vertices, head, DistributionPattern.ALL_TO_ALL);
        JobGraphUtils.connect(head, intermediate, DistributionPattern.ALL_TO_ALL);
        intermediateConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, numSubTasks);
        JobGraphUtils.connect(intermediate, ssJoinIntermediate, DistributionPattern.POINTWISE);
        ssJoinIntermediateConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, 1);
        JobGraphUtils.connect(ssJoinIntermediate, ssTail, DistributionPattern.POINTWISE);
        ssTailConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, 1);
        JobGraphUtils.connect(ssJoinIntermediate, wsTail, DistributionPattern.POINTWISE);
        wsTailConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, 1);
        JobGraphUtils.connect(head, (JobVertex)output, DistributionPattern.POINTWISE);
        JobGraphUtils.connect(head, sync, DistributionPattern.POINTWISE);
        SlotSharingGroup sharingGroup = new SlotSharingGroup();
        vertices.setSlotSharingGroup(sharingGroup);
        edges.setSlotSharingGroup(sharingGroup);
        head.setSlotSharingGroup(sharingGroup);
        intermediate.setSlotSharingGroup(sharingGroup);
        ssJoinIntermediate.setSlotSharingGroup(sharingGroup);
        wsTail.setSlotSharingGroup(sharingGroup);
        ssTail.setSlotSharingGroup(sharingGroup);
        output.setSlotSharingGroup(sharingGroup);
        sync.setSlotSharingGroup(sharingGroup);
        intermediate.setStrictlyCoLocatedWith(head);
        ssJoinIntermediate.setStrictlyCoLocatedWith(head);
        wsTail.setStrictlyCoLocatedWith(head);
        ssTail.setStrictlyCoLocatedWith(head);
        return jobGraph;
    }

    public JobGraph createJobGraphIntermediateWorksetUpdateAndSolutionSetTail(String verticesPath, String edgesPath, String resultPath, int numSubTasks, int maxIterations) {
        RecordSerializerFactory serializer = RecordSerializerFactory.get();
        RecordComparatorFactory comparator = new RecordComparatorFactory(new int[]{0}, new Class[]{LongValue.class}, new boolean[]{true});
        RecordPairComparatorFactory pairComparator = RecordPairComparatorFactory.get();
        JobGraph jobGraph = new JobGraph("Connected Components (Intermediate Workset Update, Solution Set Tail)");
        InputFormatVertex vertices = ConnectedComponentsNepheleITCase.createVerticesInput(jobGraph, verticesPath, numSubTasks, serializer, comparator);
        InputFormatVertex edges = ConnectedComponentsNepheleITCase.createEdgesInput(jobGraph, edgesPath, numSubTasks, serializer, comparator);
        JobVertex head = ConnectedComponentsNepheleITCase.createIterationHead(jobGraph, numSubTasks, serializer, comparator, pairComparator);
        TaskConfig headConfig = new TaskConfig(head.getConfiguration());
        headConfig.setWaitForSolutionSetUpdate();
        JobVertex intermediate = ConnectedComponentsNepheleITCase.createIterationIntermediate(jobGraph, numSubTasks, serializer, comparator);
        TaskConfig intermediateConfig = new TaskConfig(intermediate.getConfiguration());
        OutputFormatVertex output = ConnectedComponentsNepheleITCase.createOutput(jobGraph, resultPath, numSubTasks, serializer);
        JobVertex sync = ConnectedComponentsNepheleITCase.createSync(jobGraph, numSubTasks, maxIterations);
        JobVertex wsUpdateIntermediate = JobGraphUtils.createTask(IterationIntermediatePactTask.class, "WorksetUpdate", jobGraph, numSubTasks);
        TaskConfig wsUpdateConfig = new TaskConfig(wsUpdateIntermediate.getConfiguration());
        wsUpdateConfig.setIterationId(1);
        wsUpdateConfig.setIsWorksetIteration();
        wsUpdateConfig.setIsWorksetUpdate();
        wsUpdateConfig.addInputToGroup(0);
        wsUpdateConfig.setInputSerializer((TypeSerializerFactory)serializer, 0);
        wsUpdateConfig.addOutputShipStrategy(ShipStrategyType.FORWARD);
        wsUpdateConfig.setOutputComparator((TypeComparatorFactory)comparator, 0);
        wsUpdateConfig.setOutputSerializer((TypeSerializerFactory)serializer);
        wsUpdateConfig.setDriver(JoinWithSolutionSetSecondDriver.class);
        wsUpdateConfig.setDriverStrategy(DriverStrategy.HYBRIDHASH_BUILD_SECOND);
        wsUpdateConfig.setDriverComparator((TypeComparatorFactory)comparator, 0);
        wsUpdateConfig.setDriverPairComparator((TypePairComparatorFactory)pairComparator);
        wsUpdateConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(WorksetConnectedComponents.UpdateComponentIdMatch.class));
        JobVertex ssTail = JobGraphUtils.createTask(IterationTailPactTask.class, "IterationSolutionSetTail", jobGraph, numSubTasks);
        TaskConfig ssTailConfig = new TaskConfig(ssTail.getConfiguration());
        ssTailConfig.setIterationId(1);
        ssTailConfig.setIsSolutionSetUpdate();
        ssTailConfig.setIsWorksetIteration();
        ssTailConfig.addInputToGroup(0);
        ssTailConfig.setInputSerializer((TypeSerializerFactory)serializer, 0);
        ssTailConfig.setOutputSerializer((TypeSerializerFactory)serializer);
        ssTailConfig.setDriver(CollectorMapDriver.class);
        ssTailConfig.setDriverStrategy(DriverStrategy.COLLECTOR_MAP);
        ssTailConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(DummyMapper.class));
        JobGraphUtils.connect((JobVertex)vertices, head, DistributionPattern.ALL_TO_ALL);
        JobGraphUtils.connect((JobVertex)edges, head, DistributionPattern.ALL_TO_ALL);
        JobGraphUtils.connect((JobVertex)vertices, head, DistributionPattern.ALL_TO_ALL);
        JobGraphUtils.connect(head, intermediate, DistributionPattern.ALL_TO_ALL);
        intermediateConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, numSubTasks);
        JobGraphUtils.connect(intermediate, wsUpdateIntermediate, DistributionPattern.POINTWISE);
        wsUpdateConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, 1);
        JobGraphUtils.connect(wsUpdateIntermediate, ssTail, DistributionPattern.POINTWISE);
        ssTailConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, 1);
        JobGraphUtils.connect(head, (JobVertex)output, DistributionPattern.POINTWISE);
        JobGraphUtils.connect(head, sync, DistributionPattern.POINTWISE);
        SlotSharingGroup sharingGroup = new SlotSharingGroup();
        vertices.setSlotSharingGroup(sharingGroup);
        edges.setSlotSharingGroup(sharingGroup);
        head.setSlotSharingGroup(sharingGroup);
        intermediate.setSlotSharingGroup(sharingGroup);
        wsUpdateIntermediate.setSlotSharingGroup(sharingGroup);
        ssTail.setSlotSharingGroup(sharingGroup);
        output.setSlotSharingGroup(sharingGroup);
        sync.setSlotSharingGroup(sharingGroup);
        intermediate.setStrictlyCoLocatedWith(head);
        wsUpdateIntermediate.setStrictlyCoLocatedWith(head);
        ssTail.setStrictlyCoLocatedWith(head);
        return jobGraph;
    }

    public JobGraph createJobGraphSolutionSetUpdateAndWorksetTail(String verticesPath, String edgesPath, String resultPath, int numSubTasks, int maxIterations) {
        RecordSerializerFactory serializer = RecordSerializerFactory.get();
        RecordComparatorFactory comparator = new RecordComparatorFactory(new int[]{0}, new Class[]{LongValue.class}, new boolean[]{true});
        RecordPairComparatorFactory pairComparator = RecordPairComparatorFactory.get();
        JobGraph jobGraph = new JobGraph("Connected Components (Intermediate Solution Set Update, Workset Tail)");
        InputFormatVertex vertices = ConnectedComponentsNepheleITCase.createVerticesInput(jobGraph, verticesPath, numSubTasks, serializer, comparator);
        InputFormatVertex edges = ConnectedComponentsNepheleITCase.createEdgesInput(jobGraph, edgesPath, numSubTasks, serializer, comparator);
        JobVertex head = ConnectedComponentsNepheleITCase.createIterationHead(jobGraph, numSubTasks, serializer, comparator, pairComparator);
        JobVertex intermediate = ConnectedComponentsNepheleITCase.createIterationIntermediate(jobGraph, numSubTasks, serializer, comparator);
        TaskConfig intermediateConfig = new TaskConfig(intermediate.getConfiguration());
        OutputFormatVertex output = ConnectedComponentsNepheleITCase.createOutput(jobGraph, resultPath, numSubTasks, serializer);
        JobVertex sync = ConnectedComponentsNepheleITCase.createSync(jobGraph, numSubTasks, maxIterations);
        JobVertex ssJoinIntermediate = JobGraphUtils.createTask(IterationIntermediatePactTask.class, "Solution Set Update", jobGraph, numSubTasks);
        TaskConfig ssJoinIntermediateConfig = new TaskConfig(ssJoinIntermediate.getConfiguration());
        ssJoinIntermediateConfig.setIterationId(1);
        ssJoinIntermediateConfig.setIsSolutionSetUpdate();
        ssJoinIntermediateConfig.setIsSolutionSetUpdateWithoutReprobe();
        ssJoinIntermediateConfig.addInputToGroup(0);
        ssJoinIntermediateConfig.setInputSerializer((TypeSerializerFactory)serializer, 0);
        ssJoinIntermediateConfig.addOutputShipStrategy(ShipStrategyType.FORWARD);
        ssJoinIntermediateConfig.setOutputComparator((TypeComparatorFactory)comparator, 0);
        ssJoinIntermediateConfig.setOutputSerializer((TypeSerializerFactory)serializer);
        ssJoinIntermediateConfig.setDriver(JoinWithSolutionSetSecondDriver.class);
        ssJoinIntermediateConfig.setDriverStrategy(DriverStrategy.HYBRIDHASH_BUILD_SECOND);
        ssJoinIntermediateConfig.setDriverComparator((TypeComparatorFactory)comparator, 0);
        ssJoinIntermediateConfig.setDriverPairComparator((TypePairComparatorFactory)pairComparator);
        ssJoinIntermediateConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(WorksetConnectedComponents.UpdateComponentIdMatch.class));
        JobVertex wsTail = JobGraphUtils.createTask(IterationTailPactTask.class, "IterationWorksetTail", jobGraph, numSubTasks);
        TaskConfig wsTailConfig = new TaskConfig(wsTail.getConfiguration());
        wsTailConfig.setIterationId(1);
        wsTailConfig.setIsWorksetIteration();
        wsTailConfig.setIsWorksetUpdate();
        wsTailConfig.addInputToGroup(0);
        wsTailConfig.setInputSerializer((TypeSerializerFactory)serializer, 0);
        wsTailConfig.setOutputSerializer((TypeSerializerFactory)serializer);
        wsTailConfig.setDriver(CollectorMapDriver.class);
        wsTailConfig.setDriverStrategy(DriverStrategy.COLLECTOR_MAP);
        wsTailConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(DummyMapper.class));
        JobGraphUtils.connect((JobVertex)vertices, head, DistributionPattern.ALL_TO_ALL);
        JobGraphUtils.connect((JobVertex)edges, head, DistributionPattern.ALL_TO_ALL);
        JobGraphUtils.connect((JobVertex)vertices, head, DistributionPattern.ALL_TO_ALL);
        JobGraphUtils.connect(head, intermediate, DistributionPattern.ALL_TO_ALL);
        intermediateConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, numSubTasks);
        JobGraphUtils.connect(intermediate, ssJoinIntermediate, DistributionPattern.POINTWISE);
        ssJoinIntermediateConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, 1);
        JobGraphUtils.connect(ssJoinIntermediate, wsTail, DistributionPattern.POINTWISE);
        wsTailConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, 1);
        JobGraphUtils.connect(head, (JobVertex)output, DistributionPattern.POINTWISE);
        JobGraphUtils.connect(head, sync, DistributionPattern.POINTWISE);
        SlotSharingGroup sharingGroup = new SlotSharingGroup();
        vertices.setSlotSharingGroup(sharingGroup);
        edges.setSlotSharingGroup(sharingGroup);
        head.setSlotSharingGroup(sharingGroup);
        intermediate.setSlotSharingGroup(sharingGroup);
        ssJoinIntermediate.setSlotSharingGroup(sharingGroup);
        wsTail.setSlotSharingGroup(sharingGroup);
        output.setSlotSharingGroup(sharingGroup);
        sync.setSlotSharingGroup(sharingGroup);
        intermediate.setStrictlyCoLocatedWith(head);
        ssJoinIntermediate.setStrictlyCoLocatedWith(head);
        wsTail.setStrictlyCoLocatedWith(head);
        return jobGraph;
    }

    public static final class DummyMapper
    extends MapFunction {
        private static final long serialVersionUID = 1L;

        public void map(Record rec, Collector<Record> out) {
            out.collect((Object)rec);
        }
    }

    public static final class IdDuplicator
    extends MapFunction {
        private static final long serialVersionUID = 1L;

        public void map(Record record, Collector<Record> out) throws Exception {
            record.setField(1, record.getField(0, LongValue.class));
            out.collect((Object)record);
        }
    }
}

