/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative;

import java.io.BufferedReader;
import org.apache.flink.api.common.Plan;
import org.apache.flink.test.recordJobs.graph.WorksetConnectedComponents;
import org.apache.flink.test.testdata.ConnectedComponentsData;
import org.apache.flink.test.util.RecordAPITestBase;

public class ConnectedComponentsITCase
extends RecordAPITestBase {
    private static final long SEED = 3287269182979823L;
    private static final int NUM_VERTICES = 1000;
    private static final int NUM_EDGES = 10000;
    protected String verticesPath;
    protected String edgesPath;
    protected String resultPath;

    public ConnectedComponentsITCase() {
        this.setTaskManagerNumSlots(4);
    }

    protected void preSubmit() throws Exception {
        this.verticesPath = this.createTempFile("vertices.txt", ConnectedComponentsData.getEnumeratingVertices((int)1000));
        this.edgesPath = this.createTempFile("edges.txt", ConnectedComponentsData.getRandomOddEvenEdges((int)10000, (int)1000, (long)3287269182979823L));
        this.resultPath = this.getTempFilePath("results");
    }

    protected Plan getTestJob() {
        WorksetConnectedComponents cc = new WorksetConnectedComponents();
        return cc.getPlan(Integer.valueOf(4).toString(), this.verticesPath, this.edgesPath, this.resultPath, "100");
    }

    protected void postSubmit() throws Exception {
        for (BufferedReader reader : ConnectedComponentsITCase.getResultReader((String)this.resultPath)) {
            ConnectedComponentsData.checkOddEvenResult((BufferedReader)reader);
        }
    }
}

