/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.LocalCollectionOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.test.util.JavaProgramTestBase;
import org.apache.flink.util.Collector;
import org.junit.Assert;

public class BulkIterationWithAllReducerITCase
extends JavaProgramTestBase {
    protected void testProgram() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource data = env.fromElements((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8});
        IterativeDataSet iteration = data.iterate(10);
        SingleInputUdfOperator result = data.reduceGroup((GroupReduceFunction)new PickOneAllReduce()).withBroadcastSet((DataSet)iteration, "bc");
        ArrayList resultList = new ArrayList();
        iteration.closeWith((DataSet)result).output((OutputFormat)new LocalCollectionOutputFormat(resultList));
        env.execute();
        Assert.assertEquals((long)8L, (long)((Integer)resultList.get(0)).intValue());
    }

    public static class PickOneAllReduce
    extends RichGroupReduceFunction<Integer, Integer> {
        private Integer bcValue;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void open(Configuration parameters) {
            List bc;
            List list = bc = this.getRuntimeContext().getBroadcastVariable("bc");
            synchronized (list) {
                this.bcValue = bc.isEmpty() ? null : (Integer)bc.iterator().next();
            }
        }

        public void reduce(Iterable<Integer> records, Collector<Integer> out) {
            if (this.bcValue == null) {
                return;
            }
            int x = this.bcValue;
            for (Integer y : records) {
                if (y <= x) continue;
                out.collect((Object)y);
                return;
            }
            out.collect((Object)this.bcValue);
        }
    }
}

