/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.io;

import java.io.File;
import java.nio.charset.Charset;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.shaded.com.google.common.base.Charsets;
import org.apache.flink.shaded.com.google.common.io.Files;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CsvReaderWithPOJOITCase
extends MultipleProgramsTestBase {
    private String resultPath;
    private String expected;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    public CsvReaderWithPOJOITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }

    @Before
    public void before() throws Exception {
        this.resultPath = this.tempFolder.newFile("result").toURI().toString();
    }

    @After
    public void after() throws Exception {
        CsvReaderWithPOJOITCase.compareResultsByLinesInMemory((String)this.expected, (String)this.resultPath);
    }

    private String createInputData(String data) throws Exception {
        File file = this.tempFolder.newFile("input");
        Files.write((CharSequence)data, (File)file, (Charset)Charsets.UTF_8);
        return file.toURI().toString();
    }

    @Test
    public void testPOJOType() throws Exception {
        String inputData = "ABC,2.20,3\nDEF,5.1,5\nDEF,3.30,1\nGHI,3.30,10";
        String dataPath = this.createInputData("ABC,2.20,3\nDEF,5.1,5\nDEF,3.30,1\nGHI,3.30,10");
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource data = env.readCsvFile(dataPath).pojoType(POJOItem.class, new String[]{"f1", "f3", "f2"});
        data.writeAsText(this.resultPath);
        env.execute();
        this.expected = "ABC,3,2.20\nDEF,5,5.10\nDEF,1,3.30\nGHI,10,3.30";
    }

    @Test
    public void testPOJOTypeWithFieldsOrder() throws Exception {
        String inputData = "2.20,ABC,3\n5.1,DEF,5\n3.30,DEF,1\n3.30,GHI,10";
        String dataPath = this.createInputData("2.20,ABC,3\n5.1,DEF,5\n3.30,DEF,1\n3.30,GHI,10");
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource data = env.readCsvFile(dataPath).pojoType(POJOItem.class, new String[]{"f3", "f1", "f2"});
        data.writeAsText(this.resultPath);
        env.execute();
        this.expected = "ABC,3,2.20\nDEF,5,5.10\nDEF,1,3.30\nGHI,10,3.30";
    }

    @Test
    public void testPOJOTypeWithoutFieldsOrder() throws Exception {
        String inputData = "";
        String dataPath = this.createInputData("");
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        try {
            env.readCsvFile(dataPath).pojoType(POJOItem.class, null);
            Assert.fail((String)"POJO type without fields order must raise NullPointerException!");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expected = "";
        this.resultPath = dataPath;
    }

    @Test
    public void testPOJOTypeWithFieldsOrderAndFieldsSelection() throws Exception {
        String inputData = "3,2.20,ABC\n5,5.1,DEF\n1,3.30,DEF\n10,3.30,GHI";
        String dataPath = this.createInputData("3,2.20,ABC\n5,5.1,DEF\n1,3.30,DEF\n10,3.30,GHI");
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource data = env.readCsvFile(dataPath).includeFields(new boolean[]{true, false, true}).pojoType(POJOItem.class, new String[]{"f2", "f1"});
        data.writeAsText(this.resultPath);
        env.execute();
        this.expected = "ABC,3,0.00\nDEF,5,0.00\nDEF,1,0.00\nGHI,10,0.00";
    }

    public static class POJOItem {
        public String f1;
        private int f2;
        public double f3;

        public int getF2() {
            return this.f2;
        }

        public void setF2(int f2) {
            this.f2 = f2;
        }

        public String toString() {
            return String.format("%s,%d,%.02f", this.f1, this.f2, this.f3);
        }
    }
}

