/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.failingPrograms;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.java.record.functions.MapFunction;
import org.apache.flink.api.java.record.operators.FileDataSink;
import org.apache.flink.api.java.record.operators.FileDataSource;
import org.apache.flink.api.java.record.operators.MapOperator;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.test.operators.io.ContractITCaseIOFormats;
import org.apache.flink.test.util.FailingTestBase;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;

public class TaskFailureITCase
extends FailingTestBase {
    private static final int parallelism = 4;
    private static final String MAP_IN = "1 1\n2 2\n2 8\n4 4\n4 4\n6 6\n7 7\n8 8\n1 1\n2 2\n2 2\n4 4\n4 4\n6 3\n5 9\n8 8\n1 1\n2 2\n2 2\n3 0\n4 4\n5 9\n7 7\n8 8\n1 1\n9 1\n5 9\n4 4\n4 4\n6 6\n7 7\n8 8\n";
    private static final String MAP_RESULT = "1 11\n2 12\n4 14\n4 14\n1 11\n2 12\n2 12\n4 14\n4 14\n3 16\n1 11\n2 12\n2 12\n0 13\n4 14\n1 11\n4 14\n4 14\n";
    private String inputPath;
    private String resultPath;

    public TaskFailureITCase() {
        this.setTaskManagerNumSlots(4);
    }

    protected void preSubmit() throws Exception {
        this.inputPath = this.createTempFile("input", MAP_IN);
        this.resultPath = this.getTempDirPath("result");
    }

    @Override
    protected JobGraph getFailingJobGraph() throws Exception {
        FileDataSource input = new FileDataSource((FileInputFormat)new ContractITCaseIOFormats.ContractITCaseInputFormat(), this.inputPath);
        MapOperator testMapper = MapOperator.builder(FailingMapper.class).build();
        FileDataSink output = new FileDataSink((FileOutputFormat)new ContractITCaseIOFormats.ContractITCaseOutputFormat(), this.resultPath);
        output.setInput((Operator)testMapper);
        testMapper.setInput((Operator)input);
        Plan plan = new Plan((GenericDataSinkBase)output);
        plan.setExecutionConfig(new ExecutionConfig());
        plan.setDefaultParallelism(4);
        Optimizer pc = new Optimizer(new DataStatistics(), this.config);
        OptimizedPlan op = pc.compile(plan);
        JobGraphGenerator jgg = new JobGraphGenerator();
        return jgg.compileJobGraph(op);
    }

    protected JobGraph getJobGraph() throws Exception {
        FileDataSource input = new FileDataSource((FileInputFormat)new ContractITCaseIOFormats.ContractITCaseInputFormat(), this.inputPath);
        MapOperator testMapper = MapOperator.builder(TestMapper.class).build();
        FileDataSink output = new FileDataSink((FileOutputFormat)new ContractITCaseIOFormats.ContractITCaseOutputFormat(), this.resultPath);
        output.setInput((Operator)testMapper);
        testMapper.setInput((Operator)input);
        Plan plan = new Plan((GenericDataSinkBase)output);
        plan.setExecutionConfig(new ExecutionConfig());
        plan.setDefaultParallelism(4);
        Optimizer pc = new Optimizer(new DataStatistics(), this.config);
        OptimizedPlan op = pc.compile(plan);
        JobGraphGenerator jgg = new JobGraphGenerator();
        return jgg.compileJobGraph(op);
    }

    protected void postSubmit() throws Exception {
        TaskFailureITCase.compareResultsByLinesInMemory((String)MAP_RESULT, (String)this.resultPath);
    }

    @Override
    protected int getTimeout() {
        return 30;
    }

    public static class FailingMapper
    extends MapFunction {
        private static final long serialVersionUID = 1L;

        public void map(Record record, Collector<Record> out) throws Exception {
            throw new RuntimeException("This is an expected Test Exception");
        }
    }

    public static class TestMapper
    extends MapFunction {
        private static final long serialVersionUID = 1L;
        private final StringValue string = new StringValue();
        private final IntValue integer = new IntValue();

        public void map(Record record, Collector<Record> out) throws Exception {
            StringValue valueString;
            int value;
            StringValue keyString = (StringValue)record.getField(0, (Value)this.string);
            int key = Integer.parseInt(keyString.toString());
            if (key + (value = Integer.parseInt((valueString = (StringValue)record.getField(1, (Value)this.string)).toString())) < 10) {
                record.setField(0, (Value)valueString);
                this.integer.setValue(key + 10);
                record.setField(1, (Value)this.integer);
                out.collect((Object)record);
            }
        }
    }
}

