/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.compiler.iterations;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.functions.RichJoinFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.AggregateOperator;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SolutionSetPlanNode;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class MultipleJoinsWithSolutionSetCompilerTest
extends CompilerTestBase {
    private static final String JOIN_1 = "join1";
    private static final String JOIN_2 = "join2";

    @Test
    public void testMultiSolutionSetJoinPlan() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource inputData = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)1L, (Object)1.0)});
            DataSet<Tuple2<Long, Double>> result = MultipleJoinsWithSolutionSetCompilerTest.constructPlan((DataSet<Tuple2<Long, Double>>)inputData, 10);
            result.output((OutputFormat)new DiscardingOutputFormat());
            result.output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            OptimizedPlan optPlan = this.compileNoStats((Plan)p);
            CompilerTestBase.OptimizerPlanNodeResolver or = MultipleJoinsWithSolutionSetCompilerTest.getOptimizerPlanNodeResolver((OptimizedPlan)optPlan);
            DualInputPlanNode join1 = (DualInputPlanNode)or.getNode(JOIN_1);
            DualInputPlanNode join2 = (DualInputPlanNode)or.getNode(JOIN_2);
            Assert.assertEquals((Object)DriverStrategy.HYBRIDHASH_BUILD_FIRST, (Object)join1.getDriverStrategy());
            Assert.assertEquals((Object)DriverStrategy.HYBRIDHASH_BUILD_SECOND, (Object)join2.getDriverStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)join1.getInput2().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)join2.getInput1().getShipStrategy());
            Assert.assertEquals(SolutionSetPlanNode.class, join1.getInput1().getSource().getClass());
            Assert.assertEquals(SolutionSetPlanNode.class, join2.getInput2().getSource().getClass());
            new JobGraphGenerator().compileJobGraph(optPlan);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }

    public static DataSet<Tuple2<Long, Double>> constructPlan(DataSet<Tuple2<Long, Double>> initialData, int numIterations) {
        DeltaIteration iteration = initialData.iterateDelta(initialData, numIterations, new int[]{0});
        Operator delta = ((JoinOperator)iteration.getSolutionSet().join((DataSet)iteration.getWorkset().flatMap((FlatMapFunction)new Duplicator())).where(new int[]{0}).equalTo(new int[]{0}).with((JoinFunction)new SummingJoin()).name(JOIN_1)).groupBy(new int[]{0}).aggregate(Aggregations.MIN, 1).map((MapFunction)new Expander()).join((DataSet)iteration.getSolutionSet()).where(new int[]{0}).equalTo(new int[]{0}).with((JoinFunction)new SummingJoinProject()).name(JOIN_2);
        AggregateOperator changes = delta.groupBy(new int[]{0}).aggregate(Aggregations.SUM, 1);
        DataSet result = iteration.closeWith((DataSet)delta, (DataSet)changes);
        return result;
    }

    public static final class Expander
    extends RichMapFunction<Tuple2<Long, Double>, Tuple3<Long, Double, Double>> {
        public Tuple3<Long, Double, Double> map(Tuple2<Long, Double> value) {
            return new Tuple3(value.f0, value.f1, (Object)((Double)value.f1 * 2.0));
        }
    }

    public static final class Duplicator
    extends RichFlatMapFunction<Tuple2<Long, Double>, Tuple2<Long, Double>> {
        public void flatMap(Tuple2<Long, Double> value, Collector<Tuple2<Long, Double>> out) {
            out.collect(value);
            out.collect(value);
        }
    }

    public static final class SummingJoinProject
    extends RichJoinFunction<Tuple3<Long, Double, Double>, Tuple2<Long, Double>, Tuple2<Long, Double>> {
        public Tuple2<Long, Double> join(Tuple3<Long, Double, Double> first, Tuple2<Long, Double> second) {
            return new Tuple2(first.f0, (Object)((Double)first.f1 + (Double)first.f2 + (Double)second.f1));
        }
    }

    public static final class SummingJoin
    extends RichJoinFunction<Tuple2<Long, Double>, Tuple2<Long, Double>, Tuple2<Long, Double>> {
        public Tuple2<Long, Double> join(Tuple2<Long, Double> first, Tuple2<Long, Double> second) {
            return new Tuple2(first.f0, (Object)((Double)first.f1 + (Double)second.f1));
        }
    }
}

