/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichFilterFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.AggregateDataSet;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.operators.PartitionITCase$;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.util.CollectionDataSets;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple1;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u0001=\u0011q\u0002U1si&$\u0018n\u001c8J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\t\u0011b\u001c9fe\u0006$xN]:\u000b\u0005\u00151\u0011!B:dC2\f'BA\u0004\t\u0003\r\t\u0007/\u001b\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003vi&d'BA\u000b\t\u0003\u0011!Xm\u001d;\n\u0005]\u0011\"\u0001G'vYRL\u0007\u000f\\3Qe><'/Y7t)\u0016\u001cHOQ1tK\"A\u0011\u0004\u0001B\u0001B\u0003%!$\u0001\u0003n_\u0012,\u0007CA\u000e,\u001d\ta\u0012F\u0004\u0002\u001eQ9\u0011ad\n\b\u0003?\u0019r!\u0001I\u0013\u000f\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\rr\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011Q\u0003C\u0005\u0003'QI!A\u000b\n\u000215+H\u000e^5qY\u0016\u0004&o\\4sC6\u001cH+Z:u\u0005\u0006\u001cX-\u0003\u0002-[\t\tB+Z:u\u000bb,7-\u001e;j_:lu\u000eZ3\u000b\u0005)\u0012\u0002\"B\u0018\u0001\t\u0003\u0001\u0014A\u0002\u001fj]&$h\b\u0006\u00022gA\u0011!\u0007A\u0007\u0002\u0005!)\u0011D\fa\u00015!9Q\u0007\u0001a\u0001\n\u00131\u0014A\u0003:fgVdG\u000fU1uQV\tq\u0007\u0005\u00029{9\u0011\u0011hO\u0007\u0002u)\tQ!\u0003\u0002=u\u00051\u0001K]3eK\u001aL!AP \u0003\rM#(/\u001b8h\u0015\ta$\bC\u0004B\u0001\u0001\u0007I\u0011\u0002\"\u0002\u001dI,7/\u001e7u!\u0006$\bn\u0018\u0013fcR\u00111I\u0012\t\u0003s\u0011K!!\u0012\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u000f\u0002\u000b\t\u00111\u00018\u0003\rAH%\r\u0005\u0007\u0013\u0002\u0001\u000b\u0015B\u001c\u0002\u0017I,7/\u001e7u!\u0006$\b\u000e\t\u0005\b\u0017\u0002\u0001\r\u0011\"\u00037\u0003!)\u0007\u0010]3di\u0016$\u0007bB'\u0001\u0001\u0004%IAT\u0001\rKb\u0004Xm\u0019;fI~#S-\u001d\u000b\u0003\u0007>Cqa\u0012'\u0002\u0002\u0003\u0007q\u0007\u0003\u0004R\u0001\u0001\u0006KaN\u0001\nKb\u0004Xm\u0019;fI\u0002Bqa\u0015\u0001C\u0002\u0013%A+A\u0006`i\u0016l\u0007OR8mI\u0016\u0014X#A+\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016!\u0002:vY\u0016\u001c(B\u0001.\r\u0003\u0015QWO\\5u\u0013\tavKA\bUK6\u0004xN]1ss\u001a{G\u000eZ3s\u0011\u0019q\u0006\u0001)A\u0005+\u0006aq\f^3na\u001a{G\u000eZ3sA!)\u0001\r\u0001C\u0001)\u0006QA/Z7q\r>dG-\u001a:)\u0005}\u0013\u0007CA2e\u001b\u0005I\u0016BA3Z\u0005\u0011\u0011V\u000f\\3\t\u000b\u001d\u0004A\u0011\u00015\u0002\r\t,gm\u001c:f)\u0005\u0019\u0005F\u00014k!\t\u00197.\u0003\u0002m3\n1!)\u001a4pe\u0016DQA\u001c\u0001\u0005\u0002!\fQ!\u00194uKJD#!\u001c9\u0011\u0005\r\f\u0018B\u0001:Z\u0005\u0015\te\r^3s\u0011\u0015!\b\u0001\"\u0001i\u0003u!Xm\u001d;ICND\u0007+\u0019:uSRLwN\u001c\"z)V\u0004H.\u001a$jK2$\u0007FA:w!\t\u0019w/\u0003\u0002y3\n!A+Z:u\u0011\u0015Q\b\u0001\"\u0001i\u0003y!Xm\u001d;ICND\u0007+\u0019:uSRLwN\u001c\"z\u0017\u0016L8+\u001a7fGR|'\u000f\u000b\u0002zm\")Q\u0010\u0001C\u0001Q\u0006)B/Z:u\r>\u00148-\u001a3SK\n\fG.\u00198dS:<\u0007F\u0001?w\u0011\u0019\t\t\u0001\u0001C\u0001Q\u0006)D/Z:u\u001b\u0006\u0004\b+\u0019:uSRLwN\\!gi\u0016\u0014(+\u001a9beRLG/[8o\u0011\u0006\u001c8i\u001c:sK\u000e$\b+\u0019:bY2,G.[:nQ\tyh\u000f\u0003\u0004\u0002\b\u0001!\t\u0001[\u0001-i\u0016\u001cH/T1q\u0003\u001a$XM\u001d*fa\u0006\u0014H/\u001b;j_:D\u0015m]\"peJ,7\r\u001e)be\u0006dG.\u001a7jg6D3!!\u0002w\u0011\u0019\ti\u0001\u0001C\u0001Q\u0006yC/Z:u\r&dG/\u001a:BMR,'OU3qCJ$\u0018\u000e^5p]\"\u000b7oQ8se\u0016\u001cG\u000fU1sC2dW\r\\5t[\"\u001a\u00111\u0002<\t\r\u0005M\u0001\u0001\"\u0001i\u0003]!Xm\u001d;QCJ$\u0018\u000e^5p]:+7\u000f^3e!>Tw\u000eK\u0002\u0002\u0012YDs\u0001AA\r\u0003K\t9\u0003\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\ty\"W\u0001\u0007eVtg.\u001a:\n\t\u0005\r\u0012Q\u0004\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\t\tI\u0003\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\ty#W\u0001\beVtg.\u001a:t\u0013\u0011\t\u0019$!\f\u0003\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0001")
public class PartitionITCase
extends MultipleProgramsTestBase {
    private final MultipleProgramsTestBase.TestExecutionMode mode;
    private String resultPath;
    private String org$apache$flink$api$scala$operators$PartitionITCase$$expected;
    private final TemporaryFolder _tempFolder;

    private String resultPath() {
        return this.resultPath;
    }

    private void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    public String org$apache$flink$api$scala$operators$PartitionITCase$$expected() {
        return this.org$apache$flink$api$scala$operators$PartitionITCase$$expected;
    }

    public void org$apache$flink$api$scala$operators$PartitionITCase$$expected_$eq(String x$1) {
        this.org$apache$flink$api$scala$operators$PartitionITCase$$expected = x$1;
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    @Before
    public void before() {
        this.resultPath_$eq(this.tempFolder().newFile().toURI().toString());
    }

    @After
    public void after() {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.org$apache$flink$api$scala$operators$PartitionITCase$$expected(), (String)this.resultPath());
    }

    @Test
    public void testHashPartitionByTupleField() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet unique = ds.partitionByHash((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).mapPartition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Set<Object> apply(Iterator<Tuple3<Object, Object, String>> x$1) {
                return x$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Tuple3<Object, Object, String> x$2) {
                        return BoxesRunTime.unboxToLong((Object)x$2._2());
                    }
                }).toSet();
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.org$apache$flink$api$scala$operators$PartitionITCase$$expected_$eq("1\n2\n3\n4\n5\n6\n");
    }

    @Test
    public void testHashPartitionByKeySelector() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet unique = ds.partitionByHash((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple3<Object, Object, String> x$3) {
                return BoxesRunTime.unboxToLong((Object)x$3._2());
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE)).mapPartition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Set<Object> apply(Iterator<Tuple3<Object, Object, String>> x$4) {
                return x$4.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Tuple3<Object, Object, String> x$5) {
                        return BoxesRunTime.unboxToLong((Object)x$5._2());
                    }
                }).toSet();
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.org$apache$flink$api$scala$operators$PartitionITCase$$expected_$eq("1\n2\n3\n4\n5\n6\n");
    }

    @Test
    public void testForcedRebalancing() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet ds = env.generateSequence(1L, 3000L);
        DataSet skewed = ds.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$6) {
                return this.apply$mcZJ$sp(x$6);
            }

            public boolean apply$mcZJ$sp(long x$6) {
                return x$6 > 780L;
            }
        });
        DataSet rebalanced = skewed.rebalance();
        DataSet countsInPartition = rebalanced.map((MapFunction)new RichMapFunction<Object, Tuple2<Object, Object>>(this){

            public Tuple2<Object, Object> map(long in) {
                return new Tuple2.mcIJ.sp(this.getRuntimeContext().getIndexOfThisSubtask(), 1L);
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(this){

            public TypeInformation<?>[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public Class<Tuple2<Object, Object>> protected$tupleType($anon$8 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$8 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                return new CaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> v1, Tuple2<Object, Object> v2) {
                return new Tuple2.mcIJ.sp(v1._1$mcI$sp(), v1._2$mcJ$sp() + v2._2$mcJ$sp());
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> in) {
                return new Tuple2.mcIJ.sp(in._1$mcI$sp(), in._2$mcJ$sp() / 10L);
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(this){

            public TypeInformation<?>[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public Class<Tuple2<Object, Object>> protected$tupleType($anon$9 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$9 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                return new CaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        countsInPartition.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        int numPerPartition = 2220 / env.getParallelism() / 10;
        this.org$apache$flink$api$scala$operators$PartitionITCase$$expected_$eq("");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), env.getParallelism()).foreach$mVc$sp((Function1)new Serializable(this, numPerPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionITCase $outer;
            private final int numPerPartition$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.org$apache$flink$api$scala$operators$PartitionITCase$$expected_$eq(new StringBuilder().append((Object)this.$outer.org$apache$flink$api$scala$operators$PartitionITCase$$expected()).append((Object)new StringBuilder().append((Object)"(").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)",").append((Object)BoxesRunTime.boxToInteger((int)this.numPerPartition$1)).append((Object)")\n").toString()).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.numPerPartition$1 = numPerPartition$1;
            }
        });
    }

    @Test
    public void testMapPartitionAfterRepartitionHasCorrectParallelism() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        env.setParallelism(1);
        DataSet unique = ds.partitionByHash((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).setParallelism(4).mapPartition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Set<Object> apply(Iterator<Tuple3<Object, Object, String>> x$7) {
                return x$7.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Tuple3<Object, Object, String> x$8) {
                        return BoxesRunTime.unboxToLong((Object)x$8._2());
                    }
                }).toSet();
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.org$apache$flink$api$scala$operators$PartitionITCase$$expected_$eq("1\n2\n3\n4\n5\n6\n");
    }

    @Test
    public void testMapAfterRepartitionHasCorrectParallelism() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        env.setParallelism(1);
        AggregateDataSet count = ds.partitionByHash((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).setParallelism(4).map((MapFunction)new RichMapFunction<Tuple3<Object, Object, String>, Tuple1<Object>>(this){
            private boolean first;

            public boolean first() {
                return this.first;
            }

            public void first_$eq(boolean x$1) {
                this.first = x$1;
            }

            public Tuple1<Object> map(Tuple3<Object, Object, String> in) {
                Tuple1.mcI.sp sp2;
                if (this.first()) {
                    this.first_$eq(false);
                    sp2 = new Tuple1.mcI.sp(1);
                } else {
                    sp2 = new Tuple1.mcI.sp(0);
                }
                return sp2;
            }
            {
                this.first = true;
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(this){

            public TypeInformation<?>[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public Class<Tuple1<Object>> protected$tupleType($anon$10 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$10 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                return new CaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)fields[0]));
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(Tuple1.class)).sum(0);
        count.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        MultipleProgramsTestBase.TestExecutionMode testExecutionMode = this.mode;
        MultipleProgramsTestBase.TestExecutionMode testExecutionMode2 = MultipleProgramsTestBase.TestExecutionMode.COLLECTION;
        this.org$apache$flink$api$scala$operators$PartitionITCase$$expected_$eq(!(testExecutionMode != null ? !testExecutionMode.equals(testExecutionMode2) : testExecutionMode2 != null) ? "(1)\n" : "(4)\n");
    }

    @Test
    public void testFilterAfterRepartitionHasCorrectParallelism() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        env.setParallelism(1);
        AggregateDataSet count = ds.partitionByHash((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).setParallelism(4).filter((FilterFunction)new RichFilterFunction<Tuple3<Object, Object, String>>(this){
            private boolean first;

            public boolean first() {
                return this.first;
            }

            public void first_$eq(boolean x$1) {
                this.first = x$1;
            }

            public boolean filter(Tuple3<Object, Object, String> in) {
                boolean bl;
                if (this.first()) {
                    this.first_$eq(false);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                this.first = true;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple1<Object> apply(Tuple3<Object, Object, String> x$9) {
                return new Tuple1.mcI.sp(1);
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(this){

            public TypeInformation<?>[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public Class<Tuple1<Object>> protected$tupleType($anon$11 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$11 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                return new CaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)fields[0]));
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(Tuple1.class)).sum(0);
        count.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        MultipleProgramsTestBase.TestExecutionMode testExecutionMode = this.mode;
        MultipleProgramsTestBase.TestExecutionMode testExecutionMode2 = MultipleProgramsTestBase.TestExecutionMode.COLLECTION;
        this.org$apache$flink$api$scala$operators$PartitionITCase$$expected_$eq(!(testExecutionMode != null ? !testExecutionMode.equals(testExecutionMode2) : testExecutionMode2 != null) ? "(1)\n" : "(4)\n");
    }

    @Test
    public void testPartitionNestedPojo() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(3);
        DataSet<CollectionDataSets.POJO> ds = CollectionDataSets$.MODULE$.getDuplicatePojoDataSet(env);
        DataSet uniqLongs = ds.partitionByHash("nestedPojo.longNumber", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).setParallelism(4).mapPartition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Set<Object> apply(Iterator<CollectionDataSets.POJO> x$10) {
                return x$10.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(CollectionDataSets.POJO x$11) {
                        return x$11.nestedPojo().longNumber();
                    }
                }).toSet();
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        uniqLongs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.org$apache$flink$api$scala$operators$PartitionITCase$$expected_$eq("10000\n20000\n30000\n");
    }

    public PartitionITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        this.mode = mode;
        super(mode);
        this.resultPath = null;
        this.org$apache$flink$api$scala$operators$PartitionITCase$$expected = null;
        this._tempFolder = new TemporaryFolder();
    }
}

