/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.operators.DistinctITCase$;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.util.CollectionDataSets;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple1;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\u0001=\u0011a\u0002R5ti&t7\r^%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005Iq\u000e]3sCR|'o\u001d\u0006\u0003\u000b\u0019\tQa]2bY\u0006T!a\u0002\u0005\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E1R\"\u0001\n\u000b\u0005M!\u0012\u0001B;uS2T!!\u0006\u0005\u0002\tQ,7\u000f^\u0005\u0003/I\u0011\u0001$T;mi&\u0004H.\u001a)s_\u001e\u0014\u0018-\\:UKN$()Y:f\u0011!I\u0002A!A!\u0002\u0013Q\u0012\u0001B7pI\u0016\u0004\"aG\u0016\u000f\u0005qIcBA\u000f)\u001d\tqrE\u0004\u0002 M9\u0011\u0001%\n\b\u0003C\u0011j\u0011A\t\u0006\u0003G9\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t)\u0002\"\u0003\u0002\u0014)%\u0011!FE\u0001\u0019\u001bVdG/\u001b9mKB\u0013xn\u001a:b[N$Vm\u001d;CCN,\u0017B\u0001\u0017.\u0005E!Vm\u001d;Fq\u0016\u001cW\u000f^5p]6{G-\u001a\u0006\u0003UIAQa\f\u0001\u0005\u0002A\na\u0001P5oSRtDCA\u00194!\t\u0011\u0004!D\u0001\u0003\u0011\u0015Ib\u00061\u0001\u001b\u0011\u001d)\u0004\u00011A\u0005\nY\n!B]3tk2$\b+\u0019;i+\u00059\u0004C\u0001\u001d>\u001d\tI4(D\u0001;\u0015\u0005)\u0011B\u0001\u001f;\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qR\u0004bB!\u0001\u0001\u0004%IAQ\u0001\u000fe\u0016\u001cX\u000f\u001c;QCRDw\fJ3r)\t\u0019e\t\u0005\u0002:\t&\u0011QI\u000f\u0002\u0005+:LG\u000fC\u0004H\u0001\u0006\u0005\t\u0019A\u001c\u0002\u0007a$\u0013\u0007\u0003\u0004J\u0001\u0001\u0006KaN\u0001\fe\u0016\u001cX\u000f\u001c;QCRD\u0007\u0005C\u0004L\u0001\u0001\u0007I\u0011\u0002\u001c\u0002\u0011\u0015D\b/Z2uK\u0012Dq!\u0014\u0001A\u0002\u0013%a*\u0001\u0007fqB,7\r^3e?\u0012*\u0017\u000f\u0006\u0002D\u001f\"9q\tTA\u0001\u0002\u00049\u0004BB)\u0001A\u0003&q'A\u0005fqB,7\r^3eA!91\u000b\u0001b\u0001\n\u0013!\u0016aC0uK6\u0004hi\u001c7eKJ,\u0012!\u0016\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000bQA];mKNT!A\u0017\u0007\u0002\u000b),h.\u001b;\n\u0005q;&a\u0004+f[B|'/\u0019:z\r>dG-\u001a:\t\ry\u0003\u0001\u0015!\u0003V\u00031yF/Z7q\r>dG-\u001a:!\u0011\u0015\u0001\u0007\u0001\"\u0001U\u0003)!X-\u001c9G_2$WM\u001d\u0015\u0003?\n\u0004\"a\u00193\u000e\u0003eK!!Z-\u0003\tI+H.\u001a\u0005\u0006O\u0002!\t\u0001[\u0001\u0007E\u00164wN]3\u0015\u0003\rC#A\u001a6\u0011\u0005\r\\\u0017B\u00017Z\u0005\u0019\u0011UMZ8sK\")a\u000e\u0001C\u0001Q\u0006)\u0011M\u001a;fe\"\u0012Q\u000e\u001d\t\u0003GFL!A]-\u0003\u000b\u00053G/\u001a:\t\u000bQ\u0004A\u0011\u00015\u0002kQ,7\u000f^\"peJ,7\r\u001e8fgN|e\rR5ti&t7\r^(o)V\u0004H.Z:XSRD7*Z=GS\u0016dGmU3mK\u000e$xN\u001d\u0015\u0003gZ\u0004\"aY<\n\u0005aL&\u0001\u0002+fgRDQA\u001f\u0001\u0005\u0002!\f\u0011\n^3ti\u000e{'O]3di:,7o](g\t&\u001cH/\u001b8di>sG+\u001e9mKN<\u0016\u000e\u001e5LKf4\u0015.\u001a7e'\u0016dWm\u0019;pe:{G/\u00117m\r&,G\u000eZ:TK2,7\r^3eQ\tIh\u000fC\u0003~\u0001\u0011\u0005\u0001.A\u0019uKN$8i\u001c:sK\u000e$h.Z:t\u001f\u001a$\u0015n\u001d;j]\u000e$xJ\u001c+va2,7oV5uQ.+\u00170\u0012=ue\u0006\u001cGo\u001c:)\u0005q4\bBBA\u0001\u0001\u0011\u0005\u0001.\u0001\u001cuKN$8i\u001c:sK\u000e$h.Z:t\u001f\u001a$\u0015n\u001d;j]\u000e$xJ\\\"vgR|W\u000eV=qK^KG\u000f\u001b+za\u0016,\u0005\u0010\u001e:bGR|'\u000f\u000b\u0002\u0000m\"1\u0011q\u0001\u0001\u0005\u0002!\f\u0011\u0005^3ti\u000e{'O]3di:,7o](g\t&\u001cH/\u001b8di>sG+\u001e9mKND3!!\u0002w\u0011\u0019\ti\u0001\u0001C\u0001Q\u0006!E/Z:u\u0007>\u0014(/Z2u]\u0016\u001c8o\u00144ESN$\u0018N\\2u\u001f:\u001cUo\u001d;p[RK\b/Z,ji\"$V\u000f\u001d7f%\u0016$XO\u001d8j]\u001e$\u0016\u0010]3FqR\u0014\u0018m\u0019;pe\"\u001a\u00111\u0002<\t\r\u0005M\u0001\u0001\"\u0001i\u0003U\"Xm\u001d;D_J\u0014Xm\u0019;oKN\u001cxJ\u001a#jgRLgn\u0019;P]R+\b\u000f\\3t/&$\bNR5fY\u0012,\u0005\u0010\u001d:fgNLwN\\:)\u0007\u0005Ea\u000f\u0003\u0004\u0002\u001a\u0001!\t\u0001[\u0001!i\u0016\u001cHoQ8se\u0016\u001cGO\\3tg>3G)[:uS:\u001cGo\u00148Q_*|7\u000fK\u0002\u0002\u0018YDs\u0001AA\u0010\u0003W\ti\u0003\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)#W\u0001\u0007eVtg.\u001a:\n\t\u0005%\u00121\u0005\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\t\ty\u0003\u0005\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)$W\u0001\beVtg.\u001a:t\u0013\u0011\tI$a\r\u0003\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0001")
public class DistinctITCase
extends MultipleProgramsTestBase {
    private String resultPath = null;
    private String expected = null;
    private final TemporaryFolder _tempFolder = new TemporaryFolder();

    private String resultPath() {
        return this.resultPath;
    }

    private void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    private String expected() {
        return this.expected;
    }

    private void expected_$eq(String x$1) {
        this.expected = x$1;
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    @Before
    public void before() {
        this.resultPath_$eq(this.tempFolder().newFile().toURI().toString());
    }

    @After
    public void after() {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.expected(), (String)this.resultPath());
    }

    @Test
    public void testCorrectnessOfDistinctOnTuplesWithKeyFieldSelector() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env);
        DataSet distinctDs = ds.union(ds).distinct((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        String x$6 = this.resultPath();
        FileSystem.WriteMode x$7 = FileSystem.WriteMode.OVERWRITE;
        String x$8 = distinctDs.writeAsCsv$default$2();
        String x$9 = distinctDs.writeAsCsv$default$3();
        distinctDs.writeAsCsv(x$6, x$8, x$9, x$7);
        env.execute();
        this.expected_$eq("1,1,Hi\n2,2,Hello\n3,2,Hello world\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnTuplesWithKeyFieldSelectorNotAllFieldsSelected() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.getSmall5TupleDataSet(env);
        DataSet distinctDs = ds.union(ds).distinct((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple5<Object, Object, Object, String, Object> x$1) {
                return BoxesRunTime.unboxToInt((Object)x$1._1());
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE), ClassTag$.MODULE$.Int());
        distinctDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnTuplesWithKeyExtractor() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.getSmall5TupleDataSet(env);
        DataSet reduceDs = ds.union(ds).distinct((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple5<Object, Object, Object, String, Object> x$2) {
                return BoxesRunTime.unboxToInt((Object)x$2._1());
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple5<Object, Object, Object, String, Object> x$3) {
                return BoxesRunTime.unboxToInt((Object)x$3._1());
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE), ClassTag$.MODULE$.Int());
        reduceDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnCustomTypeWithTypeExtractor() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets$.MODULE$.getCustomTypeDataSet(env);
        DataSet reduceDs = ds.distinct((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(CollectionDataSets.CustomType x$4) {
                return x$4.myInt();
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple1<Object> apply(CollectionDataSets.CustomType t) {
                return new Tuple1.mcI.sp(t.myInt());
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(this){

            public TypeInformation<?>[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public Class<Tuple1<Object>> protected$tupleType($anon$5 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$5 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                return new CaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)fields[0]));
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(Tuple1.class));
        String x$10 = this.resultPath();
        FileSystem.WriteMode x$11 = FileSystem.WriteMode.OVERWRITE;
        String x$12 = reduceDs.writeAsCsv$default$2();
        String x$13 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$10, x$12, x$13, x$11);
        env.execute();
        this.expected_$eq("1\n2\n3\n4\n5\n6\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnTuples() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env);
        DataSet distinctDs = ds.union(ds).distinct((Seq)Nil$.MODULE$);
        String x$14 = this.resultPath();
        FileSystem.WriteMode x$15 = FileSystem.WriteMode.OVERWRITE;
        String x$16 = distinctDs.writeAsCsv$default$2();
        String x$17 = distinctDs.writeAsCsv$default$3();
        distinctDs.writeAsCsv(x$14, x$16, x$17, x$15);
        env.execute();
        this.expected_$eq("1,1,Hi\n2,2,Hello\n3,2,Hello world\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnCustomTypeWithTupleReturningTypeExtractor() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.get5TupleDataSet(env);
        DataSet reduceDs = ds.distinct((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple5<Object, Object, Object, String, Object> t) {
                return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)t._1()), BoxesRunTime.unboxToLong((Object)t._5()));
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(this){

            public TypeInformation<?>[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public Class<Tuple2<Object, Object>> protected$tupleType($anon$6 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$6 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                return new CaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple5<Object, Object, Object, String, Object> t) {
                return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)t._1()), BoxesRunTime.unboxToLong((Object)t._5()));
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(this){

            public TypeInformation<?>[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public Class<Tuple2<Object, Object>> protected$tupleType($anon$7 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$7 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                return new CaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        String x$18 = this.resultPath();
        FileSystem.WriteMode x$19 = FileSystem.WriteMode.OVERWRITE;
        String x$20 = reduceDs.writeAsCsv$default$2();
        String x$21 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$18, x$20, x$21, x$19);
        env.execute();
        this.expected_$eq("1,1\n2,1\n2,2\n3,2\n3,3\n4,1\n4,2\n5,1\n5,2\n5,3\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnTuplesWithFieldExpressions() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.getSmall5TupleDataSet(env);
        DataSet reduceDs = ds.union(ds).distinct("_1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple1<Object> apply(Tuple5<Object, Object, Object, String, Object> t) {
                return new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)t._1()));
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(this){

            public TypeInformation<?>[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public Class<Tuple1<Object>> protected$tupleType($anon$8 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$8 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                return new CaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)fields[0]));
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(Tuple1.class));
        String x$22 = this.resultPath();
        FileSystem.WriteMode x$23 = FileSystem.WriteMode.OVERWRITE;
        String x$24 = reduceDs.writeAsCsv$default$2();
        String x$25 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$22, x$24, x$25, x$23);
        env.execute();
        this.expected_$eq("1\n2\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnPojos() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<CollectionDataSets.POJO> ds = CollectionDataSets$.MODULE$.getDuplicatePojoDataSet(env);
        DataSet reduceDs = ds.distinct("nestedPojo.longNumber", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(CollectionDataSets.POJO x$5) {
                return (int)x$5.nestedPojo().longNumber();
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE), ClassTag$.MODULE$.Int());
        reduceDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("10000\n20000\n30000\n");
    }

    public DistinctITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }
}

