/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.io.CollectionInputFormat;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.io.ElementType;
import org.apache.flink.core.io.GenericInputSplit;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)2A!\u0001\u0002\u0001\u001f\tI2i\u001c7mK\u000e$\u0018n\u001c8J]B,HOR8s[\u0006$H+Z:u\u0015\t\u0019A!\u0001\u0002j_*\u0011QAB\u0001\u0006g\u000e\fG.\u0019\u0006\u0003\u000f!\t1!\u00199j\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!E\n\u000e\u0003IQ\u0011!B\u0005\u0003)I\u0011a!\u00118z%\u00164\u0007\"\u0002\f\u0001\t\u00039\u0012A\u0002\u001fj]&$h\bF\u0001\u0019!\tI\u0002!D\u0001\u0003\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003M!Xm\u001d;TKJL\u0017\r\\5{C\nLG.\u001b;z)\u0005i\u0002CA\t\u001f\u0013\ty\"C\u0001\u0003V]&$\bF\u0001\u000e\"!\t\u0011S%D\u0001$\u0015\t!C\"A\u0003kk:LG/\u0003\u0002'G\t!A+Z:u\u0011\u0015A\u0003\u0001\"\u0001\u001d\u0003i!Xm\u001d;TKJL\u0017\r\\5{C\nLG.\u001b;z'R\u0014\u0018N\\4tQ\t9\u0013\u0005")
public class CollectionInputFormatTest {
    @Test
    public void testSerializability() {
        Seq inputCollection = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ElementType[]{new ElementType(1), new ElementType(2), new ElementType(3)}));
        TypeInformation info = TypeExtractor.createTypeInfo(ElementType.class);
        CollectionInputFormat inputFormat = new CollectionInputFormat((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(inputCollection).asJava(), info.createSerializer(new ExecutionConfig()));
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject(inputFormat);
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
        Object serializationResult = in.readObject();
        Assert.assertNotNull((Object)serializationResult);
        Assert.assertTrue((boolean)(serializationResult instanceof CollectionInputFormat));
        CollectionInputFormat result = (CollectionInputFormat)serializationResult;
        GenericInputSplit inputSplit = new GenericInputSplit(0, 1);
        inputFormat.open(inputSplit);
        result.open(inputSplit);
        while (!inputFormat.reachedEnd() && !result.reachedEnd()) {
            ElementType expectedElement = (ElementType)inputFormat.nextRecord(null);
            ElementType actualElement = (ElementType)result.nextRecord(null);
            Assert.assertEquals((Object)expectedElement, (Object)actualElement);
        }
        return;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSerializabilityStrings() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"To bey or not to be,--that is the question:--", "Whether 'tis nobler in the mind to suffer", "The slings and arrows of outrageous fortune", "Or to take arms against a sea of troubles,", "And by opposing end them?--To die,--to sleep,--", "No more; and by a sleep to say we end", "The heartache, and the thousand natural shocks", "That flesh is heir to,--'tis a consummation", "Devoutly to be wish'd. To die,--to sleep;--", "To sleep! perchance to dream:--ay, there's the rub;", "For in that sleep of death what dreams may come,", "When we have shuffled off this mortal coil,", "Must give us pause: there's the respect", "That makes calamity of so long life;", "For who would bear the whips and scorns of time,", "The oppressor's wrong, the proud man's contumely,", "The pangs of despis'd love, the law's delay,", "The insolence of office, and the spurns", "That patient merit of the unworthy takes,", "When he himself might his quietus make", "With a bare bodkin? who would these fardels bear,", "To grunt and sweat under a weary life,", "But that the dread of something after death,--", "The undiscover'd country, from whose bourn", "No traveller returns,--puzzles the will,", "And makes us rather bear those ills we have", "Than fly to others that we know not of?", "Thus conscience does make cowards of us all;", "And thus the native hue of resolution", "Is sicklied o'er with the pale cast of thought;", "And enterprises of great pith and moment,", "With this regard, their currents turn awry,", "And lose the name of action.--Soft you now!", "The fair Ophelia!--Nymph, in thy orisons", "Be all my sins remember'd."}));
        CollectionInputFormat inputFormat = new CollectionInputFormat((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(data).asJava(), BasicTypeInfo.STRING_TYPE_INFO.createSerializer(new ExecutionConfig()));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(inputFormat);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object result = ois.readObject();
        Assert.assertTrue((boolean)(result instanceof CollectionInputFormat));
        int i = 0;
        CollectionInputFormat in = (CollectionInputFormat)result;
        in.open(new GenericInputSplit(0, 1));
        while (true) {
            void var9_9;
            void var8_8;
            void var1_1;
            if (in.reachedEnd()) {
                Assert.assertEquals((long)data.length(), (long)i);
                return;
            }
            Assert.assertEquals((Object)var1_1.apply((int)var8_8), (Object)var9_9.nextRecord((Object)""));
            ++var8_8;
        }
    }
}

