/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.web;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.webmonitor.WebMonitor;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.concurrent.duration.FiniteDuration;

@RunWith(value=Parameterized.class)
public class WebFrontendITCase
extends MultipleProgramsTestBase {
    private static int port;
    static final FiniteDuration timeout;

    @BeforeClass
    public static void initialize() {
        WebMonitor webMonitor = (WebMonitor)cluster.webMonitor().get();
        port = webMonitor.getServerPort();
    }

    public WebFrontendITCase(MultipleProgramsTestBase.TestExecutionMode m) {
        super(m);
    }

    @Parameterized.Parameters(name="Execution mode = {0}")
    public static Collection<MultipleProgramsTestBase.TestExecutionMode[]> executionModes() {
        ArrayList<MultipleProgramsTestBase.TestExecutionMode[]> c = new ArrayList<MultipleProgramsTestBase.TestExecutionMode[]>(1);
        c.add(new MultipleProgramsTestBase.TestExecutionMode[]{MultipleProgramsTestBase.TestExecutionMode.CLUSTER});
        return c;
    }

    @Test
    public void getFrontPage() {
        try {
            String fromHTTP = TestBaseUtils.getFromHTTP((String)("http://localhost:" + port + "/index.html"));
            String text = "Apache Flink Dashboard";
            Assert.assertTrue((String)("Startpage should contain " + text), (boolean)fromHTTP.contains(text));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void getNumberOfTaskManagers() {
        try {
            String json = TestBaseUtils.getFromHTTP((String)("http://localhost:" + port + "/taskmanagers/"));
            JSONObject response = new JSONObject(json);
            JSONArray taskManagers = response.getJSONArray("taskmanagers");
            Assert.assertNotNull((Object)taskManagers);
            Assert.assertEquals((long)cluster.numTaskManagers(), (long)taskManagers.length());
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void getTaskmanagers() {
        try {
            String json = WebFrontendITCase.getFromHTTP((String)("http://localhost:" + port + "/taskmanagers/"));
            JSONObject parsed = new JSONObject(json);
            JSONArray taskManagers = parsed.getJSONArray("taskmanagers");
            Assert.assertNotNull((Object)taskManagers);
            Assert.assertEquals((long)cluster.numTaskManagers(), (long)taskManagers.length());
            JSONObject taskManager = taskManagers.getJSONObject(0);
            Assert.assertNotNull((Object)taskManager);
            Assert.assertEquals((long)4L, (long)taskManager.getInt("freeSlots"));
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void getLogAndStdoutFiles() {
        try {
            WebMonitorUtils.LogFiles logFiles = WebMonitorUtils.LogFiles.find((Configuration)cluster.configuration());
            FileUtils.writeStringToFile((File)logFiles.logFile, (String)"job manager log");
            String logs = WebFrontendITCase.getFromHTTP((String)("http://localhost:" + port + "/jobmanager/log"));
            Assert.assertTrue((boolean)logs.contains("job manager log"));
            FileUtils.writeStringToFile((File)logFiles.stdOutFile, (String)"job manager out");
            logs = WebFrontendITCase.getFromHTTP((String)("http://localhost:" + port + "/jobmanager/stdout"));
            Assert.assertTrue((boolean)logs.contains("job manager out"));
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void getConfiguration() {
        try {
            String config = WebFrontendITCase.getFromHTTP((String)("http://localhost:" + port + "/jobmanager/config"));
            JSONArray array = new JSONArray(config);
            Map conf = WebMonitorUtils.fromKeyValueJsonArray((JSONArray)array);
            Assert.assertTrue((boolean)((String)conf.get("jobmanager.web.log.path")).startsWith(logDir.toString()));
            Assert.assertEquals((Object)cluster.configuration().getString("taskmanager.numberOfTaskSlots", null), conf.get("taskmanager.numberOfTaskSlots"));
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    static {
        startWebServer = true;
        port = -1;
        timeout = new FiniteDuration(10L, TimeUnit.SECONDS);
    }
}

