/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.utils.DataSetUtils;
import org.apache.flink.shaded.com.google.common.collect.Lists;
import org.apache.flink.shaded.com.google.common.collect.Sets;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DataSetUtilsITCase
extends MultipleProgramsTestBase {
    public DataSetUtilsITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }

    @Test
    public void testZipWithIndex() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        long expectedSize = 100L;
        DataSource numbers = env.generateSequence(0L, expectedSize - 1L);
        ArrayList result = Lists.newArrayList((Iterable)DataSetUtils.zipWithIndex((DataSet)numbers).collect());
        Assert.assertEquals((long)expectedSize, (long)result.size());
        Collections.sort(result, new Comparator<Tuple2<Long, Long>>(){

            @Override
            public int compare(Tuple2<Long, Long> o1, Tuple2<Long, Long> o2) {
                return ((Long)o1.f0).compareTo((Long)o2.f0);
            }
        });
        int i = 0;
        while ((long)i < expectedSize) {
            Assert.assertEquals((long)i, (long)((Long)((Tuple2)result.get((int)i)).f0));
            ++i;
        }
    }

    @Test
    public void testZipWithUniqueId() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        long expectedSize = 100L;
        DataSource numbers = env.generateSequence(1L, expectedSize);
        MapOperator ids = DataSetUtils.zipWithUniqueId((DataSet)numbers).map((MapFunction)new MapFunction<Tuple2<Long, Long>, Long>(){

            public Long map(Tuple2<Long, Long> value) throws Exception {
                return (Long)value.f0;
            }
        });
        HashSet result = Sets.newHashSet((Iterable)ids.collect());
        Assert.assertEquals((long)expectedSize, (long)result.size());
    }
}

