/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.testPrograms.util.tests;

import org.apache.flink.test.recordJobs.util.IntTupleDataInFormat;
import org.apache.flink.test.recordJobs.util.Tuple;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.junit.Assert;
import org.junit.Test;

public class IntTupleDataInFormatTest {
    @Test
    public void testReadLineKeyValuePairOfIntValueTupleByteArray() {
        String[] testTuples = new String[]{"1|attribute1|attribute2|3|attribute4|5|", "2|3|", "3|attribute1|attribute2|", "-1|attr1|attr2|", "-2|attribute1|attribute2|", "2147483647|attr1|attr2|attr3|attr4|", "-2147483648|attr1|attr2|attr3|attr4|"};
        int[] expectedKeys = new int[]{1, 2, 3, -1, -2, Integer.MAX_VALUE, Integer.MIN_VALUE};
        int[] expectedAttrCnt = new int[]{6, 2, 3, 3, 3, 5, 5};
        IntTupleDataInFormat inFormat = new IntTupleDataInFormat();
        Record rec = new Record();
        for (int i = 0; i < testTuples.length; ++i) {
            byte[] tupleBytes = testTuples[i].getBytes();
            inFormat.readRecord(rec, tupleBytes, 0, tupleBytes.length);
            Assert.assertTrue((String)("Expected Key: " + expectedKeys[i] + " != Returned Key: " + rec.getField(0, IntValue.class)), (boolean)((IntValue)rec.getField(0, IntValue.class)).equals((Object)new IntValue(expectedKeys[i])));
            Assert.assertTrue((String)("Expected Attr Cnt: " + expectedAttrCnt[i] + " != Returned Attr Cnt: " + rec.getField(1, Tuple.class)), (((Tuple)rec.getField(1, Tuple.class)).getNumberOfColumns() == expectedAttrCnt[i] ? 1 : 0) != 0);
        }
    }
}

