/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.runtime.minicluster;

import akka.actor.ActorSystem;
import akka.testkit.JavaTestKit;
import com.typesafe.config.Config;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.AkkaActorGateway;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.minicluster.LocalFlinkMiniCluster;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class LocalFlinkMiniClusterITCase {
    static ActorSystem system;

    @BeforeClass
    public static void setup() {
        system = ActorSystem.create((String)"Testkit", (Config)AkkaUtils.getDefaultAkkaConfig());
    }

    @AfterClass
    public static void teardown() {
        JavaTestKit.shutdownActorSystem((ActorSystem)system);
        system = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalFlinkMiniClusterWithMultipleTaskManagers() {
        LocalFlinkMiniCluster miniCluster = null;
        int numTMs = 3;
        int numSlots = 14;
        try {
            Configuration config = new Configuration();
            config.setInteger("local.number-taskmanager", 3);
            config.setInteger("taskmanager.numberOfTaskSlots", 14);
            miniCluster = new LocalFlinkMiniCluster(config, true);
            miniCluster.start();
            final ActorGateway jmGateway = miniCluster.getLeaderGateway(TestingUtils.TESTING_DURATION());
            new JavaTestKit(system){
                {
                    super(x0);
                    AkkaActorGateway selfGateway = new AkkaActorGateway(this.getRef(), null);
                    new JavaTestKit.Within(TestingUtils.TESTING_DURATION(), (ActorGateway)selfGateway){
                        final /* synthetic */ ActorGateway val$selfGateway;
                        {
                            this.val$selfGateway = actorGateway;
                            super((JavaTestKit)this, x0);
                        }

                        protected void run() {
                            jmGateway.tell(JobManagerMessages.getRequestNumberRegisteredTaskManager(), this.val$selfGateway);
                            this.expectMsgEquals(TestingUtils.TESTING_DURATION(), 3);
                            jmGateway.tell(JobManagerMessages.getRequestTotalNumberOfSlots(), this.val$selfGateway);
                            this.expectMsgEquals(TestingUtils.TESTING_DURATION(), 42);
                        }
                    };
                }
            };
        }
        finally {
            if (miniCluster != null) {
                miniCluster.stop();
            }
        }
    }
}

