/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recovery;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;
import org.apache.flink.streaming.api.checkpoint.Checkpointed;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.source.RichParallelSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.test.recovery.AbstractTaskManagerProcessFailureRecoveryTest;
import org.junit.Assert;

public class TaskManagerProcessFailureStreamingRecoveryITCase
extends AbstractTaskManagerProcessFailureRecoveryTest {
    private static final int DATA_COUNT = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testTaskManagerFailure(int jobManagerPort, File coordinateDir) throws Exception {
        File tempCheckpointDir = new File(new File(ConfigConstants.DEFAULT_TASK_MANAGER_TMP_PATH), UUID.randomUUID().toString());
        Assert.assertTrue((String)"Cannot create directory for checkpoints", (boolean)tempCheckpointDir.mkdirs());
        StreamExecutionEnvironment env = StreamExecutionEnvironment.createRemoteEnvironment((String)"localhost", (int)jobManagerPort, (String[])new String[0]);
        env.setParallelism(4);
        env.getConfig().disableSysoutLogging();
        env.setNumberOfExecutionRetries(1);
        env.enableCheckpointing(200L);
        env.setStateBackend((StateBackend)new FsStateBackend(tempCheckpointDir.getAbsoluteFile().toURI()));
        SingleOutputStreamOperator result = env.addSource((SourceFunction)new SleepyDurableGenerateSequence(coordinateDir, 10000L)).map((MapFunction)new MapFunction<Long, Long>(){

            public Long map(Long value) throws Exception {
                return value;
            }
        }).startNewChain().map((MapFunction)new Mapper(coordinateDir));
        result.addSink((SinkFunction)new CheckpointedSink(10000L));
        try {
            env.execute();
        }
        finally {
            if (tempCheckpointDir.exists()) {
                FileUtils.deleteDirectory((File)tempCheckpointDir);
            }
        }
    }

    private static class CheckpointedSink
    extends RichSinkFunction<Long>
    implements Checkpointed<Long> {
        private long stepSize;
        private long congruence;
        private long toCollect;
        private Long collected = 0L;
        private long end;

        public CheckpointedSink(long end) {
            this.end = end;
        }

        public void open(Configuration parameters) throws IOException {
            this.stepSize = this.getRuntimeContext().getNumberOfParallelSubtasks();
            this.congruence = this.getRuntimeContext().getIndexOfThisSubtask();
            this.toCollect = this.end % this.stepSize > this.congruence ? this.end / this.stepSize + 1L : this.end / this.stepSize;
        }

        public void invoke(Long value) throws Exception {
            long expected = this.collected * this.stepSize + this.congruence;
            Assert.assertTrue((String)("Value did not match expected value. " + expected + " != " + value), (boolean)value.equals(expected));
            Long l = this.collected;
            Long l2 = this.collected = Long.valueOf(this.collected + 1L);
            if (this.collected > this.toCollect) {
                Assert.fail((String)("Collected <= toCollect: " + this.collected + " > " + this.toCollect));
            }
        }

        public Long snapshotState(long checkpointId, long checkpointTimestamp) throws Exception {
            return this.collected;
        }

        public void restoreState(Long state) {
            this.collected = state;
        }
    }

    public static class Mapper
    extends RichMapFunction<Long, Long> {
        private boolean markerCreated = false;
        private File coordinateDir;

        public Mapper(File coordinateDir) {
            this.coordinateDir = coordinateDir;
        }

        public Long map(Long value) throws Exception {
            if (!this.markerCreated) {
                int taskIndex = this.getRuntimeContext().getIndexOfThisSubtask();
                AbstractTaskManagerProcessFailureRecoveryTest.touchFile(new File(this.coordinateDir, "ready_" + taskIndex));
                this.markerCreated = true;
            }
            return value;
        }
    }

    public static class SleepyDurableGenerateSequence
    extends RichParallelSourceFunction<Long>
    implements Checkpointed<Long> {
        private static final long SLEEP_TIME = 50L;
        private final File coordinateDir;
        private final long end;
        private volatile boolean isRunning = true;
        private long collected;

        public SleepyDurableGenerateSequence(File coordinateDir, long end) {
            this.coordinateDir = coordinateDir;
            this.end = end;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(SourceFunction.SourceContext<Long> sourceCtx) throws Exception {
            long congruence;
            Object checkpointLock = sourceCtx.getCheckpointLock();
            RuntimeContext runtimeCtx = this.getRuntimeContext();
            long stepSize = runtimeCtx.getNumberOfParallelSubtasks();
            long toCollect = this.end % stepSize > (congruence = (long)runtimeCtx.getIndexOfThisSubtask()) ? this.end / stepSize + 1L : this.end / stepSize;
            File proceedFile = new File(this.coordinateDir, "proceed");
            boolean checkForProceedFile = true;
            while (this.isRunning && this.collected < toCollect) {
                if (checkForProceedFile) {
                    if (proceedFile.exists()) {
                        checkForProceedFile = false;
                    } else {
                        Thread.sleep(50L);
                    }
                }
                Object object = checkpointLock;
                synchronized (object) {
                    sourceCtx.collect((Object)(this.collected * stepSize + congruence));
                    ++this.collected;
                }
            }
        }

        public void cancel() {
            this.isRunning = false;
        }

        public Long snapshotState(long checkpointId, long checkpointTimestamp) {
            return this.collected;
        }

        public void restoreState(Long state) {
            this.collected = state;
        }
    }
}

