/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recovery;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.test.recovery.AbstractJobManagerProcessFailureRecoveryITCase;
import org.apache.flink.test.recovery.AbstractTaskManagerProcessFailureRecoveryTest;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JobManagerProcessFailureBatchRecoveryITCase
extends AbstractJobManagerProcessFailureRecoveryITCase {
    private final ExecutionMode executionMode;

    public JobManagerProcessFailureBatchRecoveryITCase(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> executionMode() {
        return Arrays.asList({ExecutionMode.PIPELINED}, {ExecutionMode.BATCH});
    }

    @Override
    public void testJobManagerFailure(String zkQuorum, final File coordinateDir) throws Exception {
        Configuration config = new Configuration();
        config.setString("recovery.mode", "ZOOKEEPER");
        config.setString("recovery.zookeeper.quorum", zkQuorum);
        ExecutionEnvironment env = ExecutionEnvironment.createRemoteEnvironment((String)"leader", (int)1, (Configuration)config, (String[])new String[0]);
        env.setParallelism(4);
        env.setNumberOfExecutionRetries(1);
        env.getConfig().setExecutionMode(this.executionMode);
        env.getConfig().disableSysoutLogging();
        long NUM_ELEMENTS = 100000L;
        FlatMapOperator result = env.generateSequence(1L, 100000L).rebalance().map((MapFunction)new RichMapFunction<Long, Long>(){
            private final File proceedFile;
            private boolean markerCreated;
            private boolean checkForProceedFile;
            {
                this.proceedFile = new File(coordinateDir, "proceed");
                this.markerCreated = false;
                this.checkForProceedFile = true;
            }

            public Long map(Long value) throws Exception {
                if (!this.markerCreated) {
                    int taskIndex = this.getRuntimeContext().getIndexOfThisSubtask();
                    AbstractTaskManagerProcessFailureRecoveryTest.touchFile(new File(coordinateDir, "ready_" + taskIndex));
                    this.markerCreated = true;
                }
                if (this.checkForProceedFile) {
                    if (this.proceedFile.exists()) {
                        this.checkForProceedFile = false;
                    } else {
                        Thread.sleep(100L);
                    }
                }
                return value;
            }
        }).reduce((ReduceFunction)new ReduceFunction<Long>(){

            public Long reduce(Long value1, Long value2) {
                return value1 + value2;
            }
        }).flatMap((FlatMapFunction)new RichFlatMapFunction<Long, Long>(){

            public void flatMap(Long value, Collector<Long> out) throws Exception {
                Assert.assertEquals((long)5000050000L, (long)value);
                int taskIndex = this.getRuntimeContext().getIndexOfThisSubtask();
                AbstractTaskManagerProcessFailureRecoveryTest.touchFile(new File(coordinateDir, "finish_" + taskIndex));
            }
        });
        result.output((OutputFormat)new DiscardingOutputFormat());
        env.execute();
    }
}

