/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recovery;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.StreamingMode;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.AkkaActorGateway;
import org.apache.flink.runtime.leaderelection.TestingListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.ZooKeeperLeaderRetrievalService;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.runtime.testutils.JobManagerActorTestUtils;
import org.apache.flink.runtime.testutils.JobManagerProcess;
import org.apache.flink.runtime.testutils.ZooKeeperTestUtils;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.zookeeper.ZooKeeperTestEnvironment;
import org.apache.flink.test.recovery.AbstractTaskManagerProcessFailureRecoveryTest;
import org.apache.flink.util.TestLogger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Option;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.FiniteDuration;

public abstract class AbstractJobManagerProcessFailureRecoveryITCase
extends TestLogger {
    private static final ZooKeeperTestEnvironment ZooKeeper = new ZooKeeperTestEnvironment(1);
    private static final FiniteDuration TestTimeOut = new FiniteDuration(5L, TimeUnit.MINUTES);
    private static final File FileStateBackendBasePath;
    protected static final String READY_MARKER_FILE_PREFIX = "ready_";
    protected static final String FINISH_MARKER_FILE_PREFIX = "finish_";
    protected static final String PROCEED_MARKER_FILE = "proceed";
    protected static final int PARALLELISM = 4;

    @AfterClass
    public static void tearDown() throws Exception {
        if (ZooKeeper != null) {
            ZooKeeper.shutdown();
        }
        if (FileStateBackendBasePath != null) {
            FileUtils.deleteDirectory((File)FileStateBackendBasePath);
        }
    }

    @Before
    public void cleanUp() throws Exception {
        ZooKeeper.deleteAll();
        FileUtils.cleanDirectory((File)FileStateBackendBasePath);
    }

    public abstract void testJobManagerFailure(String var1, File var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJobManagerProcessFailure() throws Exception {
        int numberOfJobManagers = 2;
        int numberOfTaskManagers = 2;
        int numberOfSlotsPerTaskManager = 2;
        Assert.assertEquals((long)4L, (long)4L);
        JobManagerProcess[] jmProcess = new JobManagerProcess[2];
        ActorSystem[] tmActorSystem = new ActorSystem[2];
        ZooKeeperLeaderRetrievalService leaderRetrievalService = null;
        File coordinateTempDir = null;
        try {
            Deadline deadline = TestTimeOut.fromNow();
            coordinateTempDir = CommonTestUtils.createTempDirectory();
            Configuration config = ZooKeeperTestUtils.createZooKeeperRecoveryModeConfig((String)ZooKeeper.getConnectString(), (String)FileStateBackendBasePath.getPath());
            jmProcess[0] = new JobManagerProcess(0, config);
            jmProcess[0].createAndStart();
            config.setInteger("taskmanager.memory.size", 4);
            config.setInteger("taskmanager.network.numberOfBuffers", 100);
            config.setInteger("taskmanager.numberOfTaskSlots", 2);
            for (int i = 0; i < 2; ++i) {
                tmActorSystem[i] = AkkaUtils.createActorSystem((Config)AkkaUtils.getDefaultAkkaConfig());
                TaskManager.startTaskManagerComponentsAndActor((Configuration)config, (ActorSystem)tmActorSystem[i], (String)"localhost", (Option)Option.empty(), (Option)Option.empty(), (boolean)false, (StreamingMode)StreamingMode.STREAMING, TaskManager.class);
            }
            ActorSystem testActorSystem = AkkaUtils.createActorSystem((Config)AkkaUtils.getDefaultAkkaConfig());
            jmProcess[0].getActorRef(testActorSystem, deadline.timeLeft());
            TestingListener leaderListener = new TestingListener();
            leaderRetrievalService = ZooKeeperUtils.createLeaderRetrievalService((Configuration)config);
            leaderRetrievalService.start((LeaderRetrievalListener)leaderListener);
            leaderListener.waitForNewLeader(deadline.timeLeft().toMillis());
            String leaderAddress = leaderListener.getAddress();
            UUID leaderId = leaderListener.getLeaderSessionID();
            ActorRef leaderRef = AkkaUtils.getActorRef((String)leaderAddress, (ActorSystem)testActorSystem, (FiniteDuration)deadline.timeLeft());
            AkkaActorGateway leaderGateway = new AkkaActorGateway(leaderRef, leaderId);
            JobManagerActorTestUtils.waitForTaskManagers((int)2, (ActorGateway)leaderGateway, (FiniteDuration)deadline.timeLeft());
            final File coordinateDirClosure = coordinateTempDir;
            final Throwable[] errorRef = new Throwable[1];
            Thread programTrigger = new Thread("Program Trigger"){

                @Override
                public void run() {
                    try {
                        AbstractJobManagerProcessFailureRecoveryITCase.this.testJobManagerFailure(ZooKeeper.getConnectString(), coordinateDirClosure);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        errorRef[0] = t;
                    }
                }
            };
            programTrigger.start();
            AbstractTaskManagerProcessFailureRecoveryTest.waitForMarkerFiles(coordinateTempDir, READY_MARKER_FILE_PREFIX, 4, deadline.timeLeft().toMillis());
            jmProcess[0].destroy();
            jmProcess[1] = new JobManagerProcess(1, config);
            jmProcess[1].createAndStart();
            jmProcess[1].getActorRef(testActorSystem, deadline.timeLeft());
            AbstractTaskManagerProcessFailureRecoveryTest.touchFile(new File(coordinateTempDir, PROCEED_MARKER_FILE));
            programTrigger.join(deadline.timeLeft().toMillis());
            AbstractTaskManagerProcessFailureRecoveryTest.waitForMarkerFiles(coordinateTempDir, FINISH_MARKER_FILE_PREFIX, 1, deadline.timeLeft().toMillis());
            Assert.assertFalse((String)"The program did not finish in time", (boolean)programTrigger.isAlive());
            if (errorRef[0] != null) {
                Throwable error = errorRef[0];
                error.printStackTrace();
                Assert.fail((String)("The program encountered a " + error.getClass().getSimpleName() + " : " + error.getMessage()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            for (JobManagerProcess p : jmProcess) {
                if (p == null) continue;
                p.printProcessLog();
            }
            Assert.fail((String)e.getMessage());
        }
        finally {
            for (int i = 0; i < 2; ++i) {
                if (tmActorSystem[i] == null) continue;
                tmActorSystem[i].shutdown();
            }
            if (leaderRetrievalService != null) {
                leaderRetrievalService.stop();
            }
            for (JobManagerProcess jmProces : jmProcess) {
                if (jmProces == null) continue;
                jmProces.destroy();
            }
            if (coordinateTempDir != null) {
                try {
                    FileUtils.deleteDirectory((File)coordinateTempDir);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    static {
        try {
            FileStateBackendBasePath = CommonTestUtils.createTempDirectory();
        }
        catch (IOException e) {
            throw new RuntimeException("Error in test setup. Could not create directory.", e);
        }
    }
}

