/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobs.wordcount;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.Program;
import org.apache.flink.api.common.ProgramDescription;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.java.record.functions.FunctionAnnotation;
import org.apache.flink.api.java.record.functions.MapFunction;
import org.apache.flink.api.java.record.functions.ReduceFunction;
import org.apache.flink.api.java.record.io.CsvOutputFormat;
import org.apache.flink.api.java.record.io.TextInputFormat;
import org.apache.flink.api.java.record.operators.FileDataSink;
import org.apache.flink.api.java.record.operators.FileDataSource;
import org.apache.flink.api.java.record.operators.MapOperator;
import org.apache.flink.api.java.record.operators.ReduceOperator;
import org.apache.flink.client.LocalExecutor;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;

public class WordCount
implements Program,
ProgramDescription {
    private static final long serialVersionUID = 1L;

    public Plan getPlan(String ... args) {
        int numSubTasks = args.length > 0 ? Integer.parseInt(args[0]) : 1;
        String dataInput = args.length > 1 ? args[1] : "";
        String output = args.length > 2 ? args[2] : "";
        FileDataSource source = new FileDataSource((FileInputFormat)new TextInputFormat(), dataInput, "Input Lines");
        MapOperator mapper = MapOperator.builder((MapFunction)new TokenizeLine()).input((Operator)source).name("Tokenize Lines").build();
        ReduceOperator reducer = ReduceOperator.builder(CountWords.class, StringValue.class, (int)0).input((Operator)mapper).name("Count Words").build();
        FileDataSink out = new FileDataSink((FileOutputFormat)new CsvOutputFormat("\n", " ", new Class[]{StringValue.class, IntValue.class}), output, (Operator)reducer, "Word Counts");
        Plan plan = new Plan((GenericDataSinkBase)out, "WordCount Example");
        plan.setDefaultParallelism(numSubTasks);
        return plan;
    }

    public String getDescription() {
        return "Parameters: <numSubStasks> <input> <output>";
    }

    public static void main(String[] args) throws Exception {
        WordCount wc = new WordCount();
        if (args.length < 3) {
            System.err.println(wc.getDescription());
            System.exit(1);
        }
        Plan plan = wc.getPlan(args);
        JobExecutionResult result = LocalExecutor.execute((Plan)plan);
        System.err.println("Total runtime: " + result.getNetRuntime(TimeUnit.MILLISECONDS) + " ms");
    }

    @ReduceOperator.Combinable
    @FunctionAnnotation.ConstantFields(value={0})
    public static class CountWords
    extends ReduceFunction {
        private static final long serialVersionUID = 1L;

        public void reduce(Iterator<Record> records, Collector<Record> out) throws Exception {
            Record element = null;
            int sum = 0;
            while (records.hasNext()) {
                element = records.next();
                int cnt = ((IntValue)element.getField(1, IntValue.class)).getValue();
                sum += cnt;
            }
            element.setField(1, (Value)new IntValue(sum));
            out.collect((Object)element);
        }

        public void combine(Iterator<Record> records, Collector<Record> out) throws Exception {
            this.reduce(records, out);
        }
    }

    public static class TokenizeLine
    extends MapFunction {
        private static final long serialVersionUID = 1L;

        public void map(Record record, Collector<Record> collector) {
            String line = ((StringValue)record.getField(0, StringValue.class)).getValue();
            line = line.replaceAll("\\W+", " ").toLowerCase();
            StringTokenizer tokenizer = new StringTokenizer(line);
            while (tokenizer.hasMoreTokens()) {
                String word = tokenizer.nextToken();
                collector.collect((Object)new Record((Value)new StringValue((CharSequence)word), (Value)new IntValue(1)));
            }
        }
    }
}

