/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobs.sort;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.Program;
import org.apache.flink.api.common.ProgramDescription;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.java.record.functions.FunctionAnnotation;
import org.apache.flink.api.java.record.functions.ReduceFunction;
import org.apache.flink.api.java.record.io.CsvInputFormat;
import org.apache.flink.api.java.record.io.CsvOutputFormat;
import org.apache.flink.api.java.record.operators.FileDataSink;
import org.apache.flink.api.java.record.operators.FileDataSource;
import org.apache.flink.api.java.record.operators.ReduceOperator;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;

public class ReduceGroupSort
implements Program,
ProgramDescription {
    private static final long serialVersionUID = 1L;

    public Plan getPlan(String ... args) {
        int numSubTasks = args.length > 0 ? Integer.parseInt(args[0]) : 1;
        String dataInput = args.length > 1 ? args[1] : "";
        String output = args.length > 2 ? args[2] : "";
        CsvInputFormat format = new CsvInputFormat(' ', new Class[]{IntValue.class, IntValue.class});
        FileDataSource input = new FileDataSource((FileInputFormat)format, dataInput, "Input");
        ReduceOperator sorter = ReduceOperator.builder((ReduceFunction)new IdentityReducer(), IntValue.class, (int)0).input((Operator)input).name("Reducer").build();
        sorter.setGroupOrder(new Ordering(1, IntValue.class, Order.ASCENDING));
        FileDataSink out = new FileDataSink((FileOutputFormat)new CsvOutputFormat(), output, (Operator)sorter, "Sorted Output");
        ((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)CsvOutputFormat.configureRecordFormat((FileDataSink)out).recordDelimiter('\n')).fieldDelimiter(' ')).field(IntValue.class, 0)).field(IntValue.class, 1);
        Plan plan = new Plan((GenericDataSinkBase)out, "SecondarySort Example");
        plan.setDefaultParallelism(numSubTasks);
        return plan;
    }

    public String getDescription() {
        return "Parameters: [numSubStasks] [input] [output]";
    }

    @FunctionAnnotation.ConstantFieldsExcept(value={0})
    public static class IdentityReducer
    extends ReduceFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void reduce(Iterator<Record> records, Collector<Record> out) {
            Record next = records.next();
            IntValue incrVal = (IntValue)next.getField(0, IntValue.class);
            incrVal.setValue(incrVal.getValue() + 100);
            next.setField(0, (Value)incrVal);
            out.collect((Object)next);
            while (records.hasNext()) {
                out.collect((Object)records.next());
            }
        }
    }
}

