/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobs.relational;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.Program;
import org.apache.flink.api.common.ProgramDescription;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.java.record.operators.FileDataSink;
import org.apache.flink.api.java.record.operators.FileDataSource;
import org.apache.flink.api.java.record.operators.JoinOperator;
import org.apache.flink.api.java.record.operators.MapOperator;
import org.apache.flink.api.java.record.operators.ReduceOperator;
import org.apache.flink.test.recordJobs.relational.query9Util.AmountAggregate;
import org.apache.flink.test.recordJobs.relational.query9Util.FilteredPartsJoin;
import org.apache.flink.test.recordJobs.relational.query9Util.IntPair;
import org.apache.flink.test.recordJobs.relational.query9Util.LineItemMap;
import org.apache.flink.test.recordJobs.relational.query9Util.OrderMap;
import org.apache.flink.test.recordJobs.relational.query9Util.OrderedPartsJoin;
import org.apache.flink.test.recordJobs.relational.query9Util.PartFilter;
import org.apache.flink.test.recordJobs.relational.query9Util.PartJoin;
import org.apache.flink.test.recordJobs.relational.query9Util.PartListJoin;
import org.apache.flink.test.recordJobs.relational.query9Util.PartsuppMap;
import org.apache.flink.test.recordJobs.relational.query9Util.StringIntPair;
import org.apache.flink.test.recordJobs.relational.query9Util.StringIntPairStringDataOutFormat;
import org.apache.flink.test.recordJobs.relational.query9Util.SupplierMap;
import org.apache.flink.test.recordJobs.relational.query9Util.SuppliersJoin;
import org.apache.flink.test.recordJobs.util.IntTupleDataInFormat;
import org.apache.flink.types.IntValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPCHQuery9
implements Program,
ProgramDescription {
    public final String ARGUMENTS = "parallelism partInputPath partSuppInputPath ordersInputPath lineItemInputPath supplierInputPath nationInputPath outputPath";
    private static Logger LOG = LoggerFactory.getLogger(TPCHQuery9.class);
    private int parallelism = 1;
    private String partInputPath;
    private String partSuppInputPath;
    private String ordersInputPath;
    private String lineItemInputPath;
    private String supplierInputPath;
    private String nationInputPath;
    private String outputPath;

    public Plan getPlan(String ... args) throws IllegalArgumentException {
        if (args.length != 8) {
            LOG.warn("number of arguments do not match!");
            this.parallelism = 1;
            this.partInputPath = "";
            this.partSuppInputPath = "";
            this.ordersInputPath = "";
            this.lineItemInputPath = "";
            this.supplierInputPath = "";
            this.nationInputPath = "";
            this.outputPath = "";
        } else {
            this.parallelism = Integer.parseInt(args[0]);
            this.partInputPath = args[1];
            this.partSuppInputPath = args[2];
            this.ordersInputPath = args[3];
            this.lineItemInputPath = args[4];
            this.supplierInputPath = args[5];
            this.nationInputPath = args[6];
            this.outputPath = args[7];
        }
        FileDataSource partInput = new FileDataSource((FileInputFormat)new IntTupleDataInFormat(), this.partInputPath, "\"part\" source");
        FileDataSource partSuppInput = new FileDataSource((FileInputFormat)new IntTupleDataInFormat(), this.partSuppInputPath, "\"partsupp\" source");
        FileDataSource ordersInput = new FileDataSource((FileInputFormat)new IntTupleDataInFormat(), this.ordersInputPath, "\"orders\" source");
        FileDataSource lineItemInput = new FileDataSource((FileInputFormat)new IntTupleDataInFormat(), this.lineItemInputPath, "\"lineitem\" source");
        FileDataSource supplierInput = new FileDataSource((FileInputFormat)new IntTupleDataInFormat(), this.supplierInputPath, "\"supplier\" source");
        FileDataSource nationInput = new FileDataSource((FileInputFormat)new IntTupleDataInFormat(), this.nationInputPath, "\"nation\" source");
        MapOperator filterPart = MapOperator.builder(PartFilter.class).name("filterParts").build();
        MapOperator mapPartsupp = MapOperator.builder(PartsuppMap.class).name("mapPartsupp").build();
        MapOperator mapOrder = MapOperator.builder(OrderMap.class).name("mapOrder").build();
        MapOperator mapLineItem = MapOperator.builder(LineItemMap.class).name("proj.Partsupp").build();
        MapOperator mapSupplier = MapOperator.builder(SupplierMap.class).name("proj.Partsupp").build();
        JoinOperator partsJoin = JoinOperator.builder(PartJoin.class, IntValue.class, (int)0, (int)0).name("partsJoin").build();
        JoinOperator orderedPartsJoin = JoinOperator.builder(OrderedPartsJoin.class, IntValue.class, (int)0, (int)0).name("orderedPartsJoin").build();
        JoinOperator suppliersJoin = JoinOperator.builder(SuppliersJoin.class, IntValue.class, (int)0, (int)0).name("suppliersJoin").build();
        JoinOperator filteredPartsJoin = JoinOperator.builder(FilteredPartsJoin.class, IntPair.class, (int)0, (int)0).name("filteredPartsJoin").build();
        JoinOperator partListJoin = JoinOperator.builder(PartListJoin.class, IntValue.class, (int)0, (int)0).name("partlistJoin").build();
        ReduceOperator sumAmountAggregate = ReduceOperator.builder(AmountAggregate.class, StringIntPair.class, (int)0).name("groupyBy").build();
        filterPart.setInput((Operator)partInput);
        mapPartsupp.setInput((Operator)partSuppInput);
        mapOrder.setInput((Operator)ordersInput);
        mapLineItem.setInput((Operator)lineItemInput);
        mapSupplier.setInput((Operator)supplierInput);
        partsJoin.setFirstInput((Operator)filterPart);
        partsJoin.setSecondInput((Operator)mapPartsupp);
        orderedPartsJoin.setFirstInput((Operator)mapOrder);
        orderedPartsJoin.setSecondInput((Operator)mapLineItem);
        suppliersJoin.setFirstInput((Operator)mapSupplier);
        suppliersJoin.setSecondInput((Operator)nationInput);
        filteredPartsJoin.setFirstInput((Operator)partsJoin);
        filteredPartsJoin.setSecondInput((Operator)orderedPartsJoin);
        partListJoin.setFirstInput((Operator)filteredPartsJoin);
        partListJoin.setSecondInput((Operator)suppliersJoin);
        sumAmountAggregate.setInput((Operator)partListJoin);
        FileDataSink result = new FileDataSink((FileOutputFormat)new StringIntPairStringDataOutFormat(), this.outputPath, "Results sink");
        result.setInput((Operator)sumAmountAggregate);
        Plan p = new Plan((GenericDataSinkBase)result, "TPC-H query 9");
        p.setDefaultParallelism(this.parallelism);
        return p;
    }

    public String getDescription() {
        return "TPC-H query 9, parameters: " + this.ARGUMENTS;
    }
}

