/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobs.kmeans.udfs;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.apache.flink.api.java.record.io.DelimitedOutputFormat;
import org.apache.flink.test.recordJobs.kmeans.udfs.CoordVector;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;

public class PointOutFormat
extends DelimitedOutputFormat {
    private static final long serialVersionUID = 1L;
    private final DecimalFormat df = new DecimalFormat("####0.00");
    private final StringBuilder line = new StringBuilder();

    public PointOutFormat() {
        DecimalFormatSymbols dfSymbols = new DecimalFormatSymbols();
        dfSymbols.setDecimalSeparator('.');
        this.df.setDecimalFormatSymbols(dfSymbols);
    }

    public int serializeRecord(Record record, byte[] target) {
        this.line.setLength(0);
        IntValue centerId = (IntValue)record.getField(0, IntValue.class);
        CoordVector centerPos = (CoordVector)record.getField(1, CoordVector.class);
        this.line.append(centerId.getValue());
        for (double coord : centerPos.getCoordinates()) {
            this.line.append('|');
            this.line.append(this.df.format(coord));
        }
        this.line.append('|');
        byte[] byteString = this.line.toString().getBytes();
        if (byteString.length <= target.length) {
            System.arraycopy(byteString, 0, target, 0, byteString.length);
            return byteString.length;
        }
        return -byteString.length;
    }
}

