/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobs.kmeans.udfs;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.flink.api.java.record.functions.FunctionAnnotation;
import org.apache.flink.api.java.record.functions.ReduceFunction;
import org.apache.flink.api.java.record.operators.ReduceOperator;
import org.apache.flink.test.recordJobs.kmeans.udfs.CoordVector;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;

@ReduceOperator.Combinable
@FunctionAnnotation.ConstantFields(value={1})
public class FindNearestCenter
extends ReduceFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IntValue centerId = new IntValue();
    private final CoordVector position = new CoordVector();
    private final IntValue one = new IntValue(1);
    private final Record result = new Record(3);
    private final Record nearest = new Record();

    public void reduce(Iterator<Record> pointsWithDistance, Collector<Record> out) {
        double nearestDistance = Double.MAX_VALUE;
        int nearestClusterId = 0;
        while (pointsWithDistance.hasNext()) {
            Record res = pointsWithDistance.next();
            double distance = ((DoubleValue)res.getField(3, DoubleValue.class)).getValue();
            if (!(distance < nearestDistance)) continue;
            nearestDistance = distance;
            nearestClusterId = ((IntValue)res.getField(2, IntValue.class)).getValue();
            res.getFieldInto(1, (Value)this.position);
        }
        this.centerId.setValue(nearestClusterId);
        this.result.setField(0, (Value)this.centerId);
        this.result.setField(1, (Value)this.position);
        this.result.setField(2, (Value)this.one);
        out.collect((Object)this.result);
    }

    public void combine(Iterator<Record> pointsWithDistance, Collector<Record> out) {
        double nearestDistance = Double.MAX_VALUE;
        while (pointsWithDistance.hasNext()) {
            Record res = pointsWithDistance.next();
            double distance = ((DoubleValue)res.getField(3, DoubleValue.class)).getValue();
            if (!(distance < nearestDistance)) continue;
            nearestDistance = distance;
            res.copyTo(this.nearest);
        }
        out.collect((Object)this.nearest);
    }
}

