/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobs.kmeans.udfs;

import java.io.Serializable;
import org.apache.flink.api.java.record.functions.CrossFunction;
import org.apache.flink.api.java.record.functions.FunctionAnnotation;
import org.apache.flink.test.recordJobs.kmeans.udfs.CoordVector;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;

@FunctionAnnotation.ConstantFieldsFirst(value={0, 1})
public class ComputeDistance
extends CrossFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DoubleValue distance = new DoubleValue();

    public Record cross(Record dataPointRecord, Record clusterCenterRecord) throws Exception {
        CoordVector dataPoint = (CoordVector)dataPointRecord.getField(1, CoordVector.class);
        IntValue clusterCenterId = (IntValue)clusterCenterRecord.getField(0, IntValue.class);
        CoordVector clusterPoint = (CoordVector)clusterCenterRecord.getField(1, CoordVector.class);
        this.distance.setValue(dataPoint.computeEuclidianDistance(clusterPoint));
        dataPointRecord.setField(2, (Value)clusterCenterId);
        dataPointRecord.setField(3, (Value)this.distance);
        return dataPointRecord;
    }
}

