/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobTests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.Program;
import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.api.common.distributions.UniformIntegerDistribution;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.java.record.io.CsvInputFormat;
import org.apache.flink.api.java.record.io.CsvOutputFormat;
import org.apache.flink.api.java.record.operators.FileDataSink;
import org.apache.flink.api.java.record.operators.FileDataSource;
import org.apache.flink.test.util.RecordAPITestBase;
import org.apache.flink.types.IntValue;

public class GlobalSortingITCase
extends RecordAPITestBase {
    private static final int NUM_RECORDS = 100000;
    private String recordsPath;
    private String resultPath;
    private String sortedRecords;

    public GlobalSortingITCase() {
        this.setTaskManagerNumSlots(4);
    }

    protected void preSubmit() throws Exception {
        ArrayList<Integer> records = new ArrayList<Integer>();
        Random rnd = new Random(1988L);
        StringBuilder sb = new StringBuilder(700000);
        for (int i = 0; i < 100000; ++i) {
            int number = rnd.nextInt();
            records.add(number);
            sb.append(number);
            sb.append('\n');
        }
        this.recordsPath = this.createTempFile("records", sb.toString());
        this.resultPath = this.getTempDirPath("result");
        Collections.sort(records);
        sb.setLength(0);
        for (Integer i : records) {
            sb.append(i);
            sb.append('\n');
        }
        this.sortedRecords = sb.toString();
    }

    protected Plan getTestJob() {
        GlobalSort globalSort = new GlobalSort();
        return globalSort.getPlan(Integer.valueOf(4).toString(), this.recordsPath, this.resultPath);
    }

    protected void postSubmit() throws Exception {
        GlobalSortingITCase.compareResultsByLinesInMemoryWithStrictOrder((String)this.sortedRecords, (String)this.resultPath);
    }

    private static class GlobalSort
    implements Program {
        private static final long serialVersionUID = 1L;

        private GlobalSort() {
        }

        public Plan getPlan(String ... args) throws IllegalArgumentException {
            int numSubtasks = args.length > 0 ? Integer.parseInt(args[0]) : 1;
            String recordsPath = args.length > 1 ? args[1] : "";
            String output = args.length > 2 ? args[2] : "";
            FileDataSource source = new FileDataSource(CsvInputFormat.class, recordsPath);
            source.setParallelism(numSubtasks);
            ((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)CsvInputFormat.configureRecordFormat((FileDataSource)source).recordDelimiter('\n')).fieldDelimiter('|')).field(IntValue.class, 0);
            FileDataSink sink = new FileDataSink(CsvOutputFormat.class, output);
            sink.setParallelism(numSubtasks);
            ((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)CsvOutputFormat.configureRecordFormat((FileDataSink)sink).recordDelimiter('\n')).fieldDelimiter('|')).lenient(true)).field(IntValue.class, 0);
            sink.setGlobalOrder(new Ordering(0, IntValue.class, Order.ASCENDING), (DataDistribution)new UniformIntegerDistribution(Integer.MIN_VALUE, Integer.MAX_VALUE));
            sink.setInput((Operator)source);
            return new Plan((GenericDataSinkBase)sink);
        }
    }
}

