/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.optimizer.jsonplan;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.Plan;
import org.apache.flink.client.program.OptimizerPlanEnvironment;
import org.apache.flink.client.program.PreviewPlanEnvironment;
import org.apache.flink.examples.java.clustering.KMeans;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plandump.PlanJSONDumpGenerator;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.test.recordJobs.graph.DeltaPageRankWithInitialDeltas;
import org.apache.flink.test.recordJobs.kmeans.KMeansBroadcast;
import org.apache.flink.test.recordJobs.kmeans.KMeansSingleStep;
import org.apache.flink.test.recordJobs.relational.TPCHQuery3;
import org.apache.flink.test.recordJobs.relational.WebLogAnalysis;
import org.apache.flink.test.recordJobs.wordcount.WordCount;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.junit.Assert;
import org.junit.Test;

public class DumpCompiledPlanTest
extends CompilerTestBase {
    @Test
    public void dumpWordCount() {
        this.dump(new WordCount().getPlan(DEFAULT_PARALLELISM_STRING, IN_FILE, OUT_FILE));
    }

    @Test
    public void dumpTPCH3() {
        this.dump(new TPCHQuery3().getPlan(DEFAULT_PARALLELISM_STRING, IN_FILE, IN_FILE, OUT_FILE));
    }

    @Test
    public void dumpKMeans() {
        this.dump(new KMeansSingleStep().getPlan(DEFAULT_PARALLELISM_STRING, IN_FILE, IN_FILE, OUT_FILE));
    }

    @Test
    public void dumpIterativeKMeans() {
        PreviewPlanEnvironment env = new PreviewPlanEnvironment();
        env.setAsContext();
        try {
            KMeans.main((String[])new String[]{IN_FILE, IN_FILE, OUT_FILE, "123"});
        }
        catch (OptimizerPlanEnvironment.ProgramAbortException programAbortException) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"KMeans failed with an exception");
        }
        this.dump(env.getPlan());
    }

    @Test
    public void dumpWebLogAnalysis() {
        this.dump(new WebLogAnalysis().getPlan(DEFAULT_PARALLELISM_STRING, IN_FILE, IN_FILE, IN_FILE, OUT_FILE));
    }

    @Test
    public void dumpBulkIterationKMeans() {
        this.dump(new KMeansBroadcast().getPlan(DEFAULT_PARALLELISM_STRING, IN_FILE, OUT_FILE));
    }

    @Test
    public void dumpDeltaPageRank() {
        this.dump(new DeltaPageRankWithInitialDeltas().getPlan(DEFAULT_PARALLELISM_STRING, IN_FILE, IN_FILE, IN_FILE, OUT_FILE, "10"));
    }

    private void dump(Plan p) {
        p.setExecutionConfig(new ExecutionConfig());
        try {
            OptimizedPlan op = this.compileNoStats(p);
            PlanJSONDumpGenerator dumper = new PlanJSONDumpGenerator();
            String json = dumper.getOptimizerPlanAsJSON(op);
            JsonParser parser = new JsonFactory().createJsonParser(json);
            while (parser.nextToken() != null) {
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
            Assert.fail((String)("JSON Generator produced malformatted output: " + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("An error occurred in the test: " + e.getMessage()));
        }
    }
}

