/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.operators;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.base.FileDataSourceBase;
import org.apache.flink.api.java.record.functions.CoGroupFunction;
import org.apache.flink.api.java.record.io.DelimitedInputFormat;
import org.apache.flink.api.java.record.io.FileOutputFormat;
import org.apache.flink.api.java.record.operators.CoGroupOperator;
import org.apache.flink.api.java.record.operators.FileDataSink;
import org.apache.flink.api.java.record.operators.FileDataSource;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.test.util.RecordAPITestBase;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CoGroupITCase
extends RecordAPITestBase {
    String leftInPath = null;
    String rightInPath = null;
    String resultPath = null;
    private static final String LEFT_IN = "1 1\n2 2\n3 3\n4 4\n1 2\n2 3\n3 4\n4 5\n1 3\n2 4\n3 5\n4 6\n1 4\n2 5\n3 6\n4 7\n";
    private static final String RIGHT_IN = "1 1\n2 2\n3 3\n5 1\n1 1\n2 2\n3 3\n6 1\n1 1\n2 2\n2 2\n7 1\n1 1\n2 2\n2 2\n8 1\n";
    private static final String RESULT = "1 6\n2 2\n3 12\n4 22\n5 -1\n6 -1\n7 -1\n8 -1\n";

    public CoGroupITCase(Configuration testConfig) {
        super(testConfig);
    }

    protected void preSubmit() throws Exception {
        this.leftInPath = this.createTempFile("left_in.txt", LEFT_IN);
        this.rightInPath = this.createTempFile("right_in.txt", RIGHT_IN);
        this.resultPath = this.getTempDirPath("result");
    }

    protected Plan getTestJob() {
        FileDataSource input_left = new FileDataSource((FileInputFormat)new CoGroupTestInFormat(), this.leftInPath);
        DelimitedInputFormat.configureDelimitedFormat((FileDataSourceBase)input_left).recordDelimiter('\n');
        input_left.setParallelism(this.config.getInteger("CoGroupTest#NoSubtasks", 1));
        FileDataSource input_right = new FileDataSource((FileInputFormat)new CoGroupTestInFormat(), this.rightInPath);
        DelimitedInputFormat.configureDelimitedFormat((FileDataSourceBase)input_right).recordDelimiter('\n');
        input_right.setParallelism(this.config.getInteger("CoGroupTest#NoSubtasks", 1));
        CoGroupOperator testCoGrouper = CoGroupOperator.builder((CoGroupFunction)new TestCoGrouper(), StringValue.class, (int)0, (int)0).build();
        testCoGrouper.setParallelism(this.config.getInteger("CoGroupTest#NoSubtasks", 1));
        testCoGrouper.getParameters().setString("LOCAL_STRATEGY", this.config.getString("CoGroupTest#LocalStrategy", ""));
        testCoGrouper.getParameters().setString("INPUT_SHIP_STRATEGY", this.config.getString("CoGroupTest#ShipStrategy", ""));
        FileDataSink output = new FileDataSink((org.apache.flink.api.common.io.FileOutputFormat)new CoGroupOutFormat(), this.resultPath);
        output.setParallelism(1);
        output.setInput((Operator)testCoGrouper);
        testCoGrouper.setFirstInput((Operator)input_left);
        testCoGrouper.setSecondInput((Operator)input_right);
        return new Plan((GenericDataSinkBase)output);
    }

    protected void postSubmit() throws Exception {
        CoGroupITCase.compareResultsByLinesInMemory((String)RESULT, (String)this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> tConfigs = new LinkedList<Configuration>();
        String[] localStrategies = new String[]{"LOCAL_STRATEGY_SORT_BOTH_MERGE"};
        String[] shipStrategies = new String[]{"SHIP_REPARTITION_HASH"};
        for (String localStrategy : localStrategies) {
            for (String shipStrategy : shipStrategies) {
                Configuration config = new Configuration();
                config.setString("CoGroupTest#LocalStrategy", localStrategy);
                config.setString("CoGroupTest#ShipStrategy", shipStrategy);
                config.setInteger("CoGroupTest#NoSubtasks", 4);
                tConfigs.add(config);
            }
        }
        return CoGroupITCase.toParameterList(tConfigs);
    }

    public static class TestCoGrouper
    extends CoGroupFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private StringValue keyString = new StringValue();
        private StringValue valueString = new StringValue();

        public void coGroup(Iterator<Record> records1, Iterator<Record> records2, Collector<Record> out) {
            Record record = null;
            int sum = 0;
            while (records1.hasNext()) {
                record = records1.next();
                this.keyString = (StringValue)record.getField(0, (Value)this.keyString);
                this.valueString = (StringValue)record.getField(1, (Value)this.valueString);
                sum += Integer.parseInt(this.valueString.getValue());
            }
            while (records2.hasNext()) {
                record = records2.next();
                this.keyString = (StringValue)record.getField(0, (Value)this.keyString);
                this.valueString = (StringValue)record.getField(1, (Value)this.valueString);
                sum -= Integer.parseInt(this.valueString.getValue());
            }
            record.setField(1, (Value)new IntValue(sum));
            out.collect((Object)record);
        }
    }

    public static class CoGroupOutFormat
    extends FileOutputFormat {
        private static final long serialVersionUID = 1L;
        private final StringBuilder buffer = new StringBuilder();
        private final StringValue keyString = new StringValue();
        private final IntValue valueInteger = new IntValue();

        public void writeRecord(Record record) throws IOException {
            this.buffer.setLength(0);
            this.buffer.append(((StringValue)record.getField(0, (Value)this.keyString)).toString());
            this.buffer.append(' ');
            this.buffer.append(((IntValue)record.getField(1, (Value)this.valueInteger)).getValue());
            this.buffer.append('\n');
            byte[] bytes = this.buffer.toString().getBytes();
            this.stream.write(bytes);
        }
    }

    public static class CoGroupTestInFormat
    extends DelimitedInputFormat {
        private static final long serialVersionUID = 1L;
        private final StringValue keyString = new StringValue();
        private final StringValue valueString = new StringValue();

        public Record readRecord(Record target, byte[] bytes, int offset, int numBytes) {
            this.keyString.setValueAscii(bytes, offset, 1);
            this.valueString.setValueAscii(bytes, offset + 2, 1);
            target.setField(0, (Value)this.keyString);
            target.setField(1, (Value)this.valueString);
            return target;
        }
    }
}

