/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.manual;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongComparator;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArraySerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.TupleComparator;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.operators.hash.MutableHashTable;
import org.apache.flink.util.MutableObjectIterator;
import org.junit.Assert;

public class HashTableRecordWidthCombinations {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        TupleSerializer buildSerializer = new TupleSerializer(Tuple2.class, new TypeSerializer[]{LongSerializer.INSTANCE, BytePrimitiveArraySerializer.INSTANCE});
        LongSerializer probeSerializer = LongSerializer.INSTANCE;
        TupleComparator buildComparator = new TupleComparator(new int[]{0}, new TypeComparator[]{new LongComparator(true)}, new TypeSerializer[]{LongSerializer.INSTANCE});
        LongComparator probeComparator = new LongComparator(true);
        TypePairComparator<Long, Tuple2<Long, byte[]>> pairComparator = new TypePairComparator<Long, Tuple2<Long, byte[]>>(){
            private long ref;

            public void setReference(Long reference) {
                this.ref = reference;
            }

            public boolean equalToReference(Tuple2<Long, byte[]> candidate) {
                return (Long)candidate.f0 == this.ref;
            }

            public int compareToReference(Tuple2<Long, byte[]> candidate) {
                long x = this.ref;
                long y = (Long)candidate.f0;
                return x < y ? -1 : (x == y ? 0 : 1);
            }
        };
        IOManagerAsync ioMan = new IOManagerAsync();
        try {
            int pageSize = 32768;
            int numSegments = 34;
            for (int num = 3400; num < 3550; ++num) {
                final int numRecords = num;
                for (int recordLen = 270; recordLen < 320; ++recordLen) {
                    final byte[] payload = new byte[recordLen - 8 - 4];
                    System.out.println("testing " + numRecords + " / " + recordLen);
                    List<MemorySegment> memory = HashTableRecordWidthCombinations.getMemory(34, 32768);
                    MutableHashTable table = new MutableHashTable((TypeSerializer)buildSerializer, (TypeSerializer)probeSerializer, (TypeComparator)buildComparator, (TypeComparator)probeComparator, (TypePairComparator)pairComparator, memory, (IOManager)ioMan, 16, false);
                    MutableObjectIterator<Tuple2<Long, byte[]>> buildInput = new MutableObjectIterator<Tuple2<Long, byte[]>>(){
                        private int count = 0;

                        public Tuple2<Long, byte[]> next(Tuple2<Long, byte[]> reuse) {
                            return this.next();
                        }

                        public Tuple2<Long, byte[]> next() {
                            if (this.count++ < numRecords) {
                                return new Tuple2((Object)42L, (Object)payload);
                            }
                            return null;
                        }
                    };
                    MutableObjectIterator<Long> probeInput = new MutableObjectIterator<Long>(){
                        private final long numRecords = 10000L;
                        private long value = 0L;

                        public Long next(Long aLong) {
                            return this.next();
                        }

                        public Long next() {
                            if (this.value < 10000L) {
                                return this.value++;
                            }
                            return null;
                        }
                    };
                    table.open((MutableObjectIterator)buildInput, (MutableObjectIterator)probeInput);
                    try {
                        while (table.nextRecord()) {
                            MutableHashTable.HashBucketIterator matches = table.getBuildSideIterator();
                            while (matches.next() != null) {
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        if (!e.getMessage().contains("exceeded maximum number of recursions")) {
                            throw e;
                        }
                    }
                    finally {
                        table.close();
                    }
                    HashTableRecordWidthCombinations.checkNoTempFilesRemain((IOManager)ioMan);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            ioMan.shutdown();
        }
    }

    private static List<MemorySegment> getMemory(int numSegments, int segmentSize) {
        ArrayList<MemorySegment> list = new ArrayList<MemorySegment>(numSegments);
        for (int i = 0; i < numSegments; ++i) {
            list.add(MemorySegmentFactory.allocateUnpooledSegment((int)segmentSize));
        }
        return list;
    }

    private static void checkNoTempFilesRemain(IOManager ioManager) {
        for (File dir : ioManager.getSpillingDirectories()) {
            for (String file : dir.list()) {
                if (file == null || file.equals(".") || file.equals("..")) continue;
                Assert.fail((String)("hash table did not clean up temp files. remaining file: " + file));
            }
        }
    }
}

