/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.javaApiOperators;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.test.javaApiOperators.util.CollectionDataSets;
import org.apache.flink.test.util.JavaProgramTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.util.Collector;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TypeHintITCase
extends JavaProgramTestBase {
    private static int NUM_PROGRAMS = 3;
    private int curProgId;

    public TypeHintITCase(Configuration config) {
        super(config);
        this.curProgId = this.config.getInteger("ProgramId", -1);
    }

    protected void testProgram() throws Exception {
        TypeHintProgs.runProgram(this.curProgId);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> tConfigs = new LinkedList<Configuration>();
        for (int i = 1; i <= NUM_PROGRAMS; ++i) {
            Configuration config = new Configuration();
            config.setInteger("ProgramId", i);
            tConfigs.add(config);
        }
        return TypeHintITCase.toParameterList(tConfigs);
    }

    public static class FlatMapper<T, V>
    implements FlatMapFunction<T, V> {
        private static final long serialVersionUID = 1L;

        public void flatMap(T value, Collector<V> out) throws Exception {
            out.collect(((Tuple3)value).f0);
        }
    }

    public static class Mapper<T, V>
    implements MapFunction<T, V> {
        private static final long serialVersionUID = 1L;

        public V map(T value) throws Exception {
            return (V)value;
        }
    }

    private static class TypeHintProgs {
        private TypeHintProgs() {
        }

        public static void runProgram(int progId) throws Exception {
            switch (progId) {
                case 1: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.getSmall3TupleDataSet(env);
                    SingleInputUdfOperator identityMapDs = ds.map(new Mapper()).returns("Tuple3<Integer, Long, String>");
                    List result = identityMapDs.collect();
                    String expectedResult = "(2,2,Hello)\n(3,2,Hello world)\n(1,1,Hi)\n";
                    TestBaseUtils.compareResultAsText((List)result, (String)expectedResult);
                    break;
                }
                case 2: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.getSmall3TupleDataSet(env);
                    SingleInputUdfOperator identityMapDs = ds.map(new Mapper()).returns((TypeInformation)new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}));
                    List result = identityMapDs.collect();
                    String expectedResult = "(2,2,Hello)\n(3,2,Hello world)\n(1,1,Hi)\n";
                    TestBaseUtils.compareResultAsText((List)result, (String)expectedResult);
                    break;
                }
                case 3: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.getSmall3TupleDataSet(env);
                    SingleInputUdfOperator identityMapDs = ds.flatMap(new FlatMapper()).returns(Integer.class);
                    List result = identityMapDs.collect();
                    String expectedResult = "2\n3\n1\n";
                    TestBaseUtils.compareResultAsText((List)result, (String)expectedResult);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid program id");
                }
            }
        }
    }
}

