/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.javaApiOperators;

import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.test.javaApiOperators.util.CollectionDataSets;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.util.Collector;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FlatMapITCase
extends MultipleProgramsTestBase {
    public FlatMapITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }

    @Test
    public void testNonPassingFlatMap() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<String> ds = CollectionDataSets.getStringDataSet(env);
        FlatMapOperator nonPassingFlatMapDs = ds.flatMap((FlatMapFunction)new FlatMapper1());
        List result = nonPassingFlatMapDs.collect();
        String expected = "\n";
        FlatMapITCase.compareResultAsText((List)result, (String)expected);
    }

    @Test
    public void testDataDuplicatingFlatMap() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<String> ds = CollectionDataSets.getStringDataSet(env);
        FlatMapOperator duplicatingFlatMapDs = ds.flatMap((FlatMapFunction)new FlatMapper2());
        List result = duplicatingFlatMapDs.collect();
        String expected = "Hi\nHI\nHello\nHELLO\nHello world\nHELLO WORLD\nHello world, how are you?\nHELLO WORLD, HOW ARE YOU?\nI am fine.\nI AM FINE.\nLuke Skywalker\nLUKE SKYWALKER\nRandom comment\nRANDOM COMMENT\nLOL\nLOL\n";
        FlatMapITCase.compareResultAsText((List)result, (String)expected);
    }

    @Test
    public void testFlatMapWithVaryingNumberOfEmittedTuples() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        FlatMapOperator varyingTuplesMapDs = ds.flatMap((FlatMapFunction)new FlatMapper3());
        List result = varyingTuplesMapDs.collect();
        String expected = "1,1,Hi\n2,2,Hello\n2,2,Hello\n4,3,Hello world, how are you?\n5,3,I am fine.\n5,3,I am fine.\n7,4,Comment#1\n8,4,Comment#2\n8,4,Comment#2\n10,4,Comment#4\n11,5,Comment#5\n11,5,Comment#5\n13,5,Comment#7\n14,5,Comment#8\n14,5,Comment#8\n16,6,Comment#10\n17,6,Comment#11\n17,6,Comment#11\n19,6,Comment#13\n20,6,Comment#14\n20,6,Comment#14\n";
        FlatMapITCase.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testTypeConversionFlatMapperCustomToTuple() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets.getCustomTypeDataSet(env);
        FlatMapOperator typeConversionFlatMapDs = ds.flatMap((FlatMapFunction)new FlatMapper4());
        List result = typeConversionFlatMapDs.collect();
        String expected = "1,0,Hi\n2,1,Hello\n2,2,Hello world\n3,3,Hello world, how are you?\n3,4,I am fine.\n3,5,Luke Skywalker\n4,6,Comment#1\n4,7,Comment#2\n4,8,Comment#3\n4,9,Comment#4\n5,10,Comment#5\n5,11,Comment#6\n5,12,Comment#7\n5,13,Comment#8\n5,14,Comment#9\n6,15,Comment#10\n6,16,Comment#11\n6,17,Comment#12\n6,18,Comment#13\n6,19,Comment#14\n6,20,Comment#15\n";
        FlatMapITCase.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testTypeConversionFlatMapperTupleToBasic() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        FlatMapOperator typeConversionFlatMapDs = ds.flatMap((FlatMapFunction)new FlatMapper5());
        List result = typeConversionFlatMapDs.collect();
        String expected = "Hi\nHello\nHello world\nHello world, how are you?\nI am fine.\nLuke Skywalker\nComment#1\nComment#2\nComment#3\nComment#4\nComment#5\nComment#6\nComment#7\nComment#8\nComment#9\nComment#10\nComment#11\nComment#12\nComment#13\nComment#14\nComment#15\n";
        FlatMapITCase.compareResultAsText((List)result, (String)expected);
    }

    @Test
    public void testFlatMapperIfUDFReturnsInputObjectMultipleTimesWhileChangingIt() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        FlatMapOperator inputObjFlatMapDs = ds.flatMap((FlatMapFunction)new FlatMapper6());
        List result = inputObjFlatMapDs.collect();
        String expected = "0,1,Hi\n0,2,Hello\n1,2,Hello\n0,2,Hello world\n1,2,Hello world\n2,2,Hello world\n0,3,I am fine.\n0,3,Luke Skywalker\n1,3,Luke Skywalker\n0,4,Comment#1\n1,4,Comment#1\n2,4,Comment#1\n0,4,Comment#3\n0,4,Comment#4\n1,4,Comment#4\n0,5,Comment#5\n1,5,Comment#5\n2,5,Comment#5\n0,5,Comment#7\n0,5,Comment#8\n1,5,Comment#8\n0,5,Comment#9\n1,5,Comment#9\n2,5,Comment#9\n0,6,Comment#11\n0,6,Comment#12\n1,6,Comment#12\n0,6,Comment#13\n1,6,Comment#13\n2,6,Comment#13\n0,6,Comment#15\n";
        FlatMapITCase.compareResultAsTuples((List)result, (String)expected);
    }

    @Test
    public void testFlatMapWithBroadcastSet() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Integer> ints = CollectionDataSets.getIntegerDataSet(env);
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        SingleInputUdfOperator bcFlatMapDs = ds.flatMap((FlatMapFunction)new RichFlatMapper1()).withBroadcastSet(ints, "ints");
        List result = bcFlatMapDs.collect();
        String expected = "55,1,Hi\n55,2,Hello\n55,2,Hello world\n55,3,Hello world, how are you?\n55,3,I am fine.\n55,3,Luke Skywalker\n55,4,Comment#1\n55,4,Comment#2\n55,4,Comment#3\n55,4,Comment#4\n55,5,Comment#5\n55,5,Comment#6\n55,5,Comment#7\n55,5,Comment#8\n55,5,Comment#9\n55,6,Comment#10\n55,6,Comment#11\n55,6,Comment#12\n55,6,Comment#13\n55,6,Comment#14\n55,6,Comment#15\n";
        FlatMapITCase.compareResultAsTuples((List)result, (String)expected);
    }

    public static class RichFlatMapper1
    extends RichFlatMapFunction<Tuple3<Integer, Long, String>, Tuple3<Integer, Long, String>> {
        private static final long serialVersionUID = 1L;
        private final Tuple3<Integer, Long, String> outTuple = new Tuple3();
        private Integer f2Replace = 0;

        public void open(Configuration config) {
            List ints = this.getRuntimeContext().getBroadcastVariable("ints");
            int sum = 0;
            for (Integer i : ints) {
                sum += i.intValue();
            }
            this.f2Replace = sum;
        }

        public void flatMap(Tuple3<Integer, Long, String> value, Collector<Tuple3<Integer, Long, String>> out) throws Exception {
            this.outTuple.setFields((Object)this.f2Replace, value.f1, value.f2);
            out.collect(this.outTuple);
        }
    }

    public static class FlatMapper6
    implements FlatMapFunction<Tuple3<Integer, Long, String>, Tuple3<Integer, Long, String>> {
        private static final long serialVersionUID = 1L;

        public void flatMap(Tuple3<Integer, Long, String> value, Collector<Tuple3<Integer, Long, String>> out) throws Exception {
            int numTuples = (Integer)value.f0 % 4;
            for (int i = 0; i < numTuples; ++i) {
                value.setField((Object)i, 0);
                out.collect(value);
            }
        }
    }

    public static class FlatMapper5
    implements FlatMapFunction<Tuple3<Integer, Long, String>, String> {
        private static final long serialVersionUID = 1L;

        public void flatMap(Tuple3<Integer, Long, String> value, Collector<String> out) throws Exception {
            out.collect(value.f2);
        }
    }

    public static class FlatMapper4
    implements FlatMapFunction<CollectionDataSets.CustomType, Tuple3<Integer, Long, String>> {
        private static final long serialVersionUID = 1L;
        private final Tuple3<Integer, Long, String> outTuple = new Tuple3();

        public void flatMap(CollectionDataSets.CustomType value, Collector<Tuple3<Integer, Long, String>> out) throws Exception {
            this.outTuple.setField((Object)value.myInt, 0);
            this.outTuple.setField((Object)value.myLong, 1);
            this.outTuple.setField((Object)value.myString, 2);
            out.collect(this.outTuple);
        }
    }

    public static class FlatMapper3
    implements FlatMapFunction<Tuple3<Integer, Long, String>, Tuple3<Integer, Long, String>> {
        private static final long serialVersionUID = 1L;

        public void flatMap(Tuple3<Integer, Long, String> value, Collector<Tuple3<Integer, Long, String>> out) throws Exception {
            int numTuples = (Integer)value.f0 % 3;
            for (int i = 0; i < numTuples; ++i) {
                out.collect(value);
            }
        }
    }

    public static class FlatMapper2
    implements FlatMapFunction<String, String> {
        private static final long serialVersionUID = 1L;

        public void flatMap(String value, Collector<String> out) throws Exception {
            out.collect((Object)value);
            out.collect((Object)value.toUpperCase());
        }
    }

    public static class FlatMapper1
    implements FlatMapFunction<String, String> {
        private static final long serialVersionUID = 1L;

        public void flatMap(String value, Collector<String> out) throws Exception {
            if (value.contains("bananas")) {
                out.collect((Object)value);
            }
        }
    }
}

