/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.javaApiOperators;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.functions.RichMapPartitionFunction;
import org.apache.flink.api.common.io.GenericInputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.LocalEnvironment;
import org.apache.flink.api.java.operators.MapPartitionOperator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionEnvironmentITCase {
    private static final int PARALLELISM = 5;

    @Test
    public void testLocalEnvironmentWithConfig() throws Exception {
        Configuration conf = new Configuration();
        conf.setInteger("taskmanager.numberOfTaskSlots", 5);
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((Configuration)conf);
        env.setParallelism(Integer.MAX_VALUE);
        env.getConfig().disableSysoutLogging();
        MapPartitionOperator result = env.createInput((InputFormat)new ParallelismDependentInputFormat()).rebalance().mapPartition((MapPartitionFunction)new RichMapPartitionFunction<Integer, Integer>(){

            public void mapPartition(Iterable<Integer> values, Collector<Integer> out) throws Exception {
                out.collect((Object)this.getRuntimeContext().getIndexOfThisSubtask());
            }
        });
        List resultCollection = result.collect();
        Assert.assertEquals((long)5L, (long)resultCollection.size());
    }

    private static class ParallelismDependentInputFormat
    extends GenericInputFormat<Integer> {
        private transient boolean emitted;

        private ParallelismDependentInputFormat() {
        }

        public GenericInputSplit[] createInputSplits(int numSplits) throws IOException {
            Assert.assertEquals((long)5L, (long)numSplits);
            return super.createInputSplits(numSplits);
        }

        public boolean reachedEnd() {
            return this.emitted;
        }

        public Integer nextRecord(Integer reuse) {
            if (this.emitted) {
                return null;
            }
            this.emitted = true;
            return 1;
        }
    }
}

