/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.javaApiOperators;

import java.util.List;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.TextInputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.test.util.JavaProgramTestBase;
import org.junit.Assert;

public class DataSourceITCase
extends JavaProgramTestBase {
    private String inputPath;

    protected void preSubmit() throws Exception {
        this.inputPath = this.createTempFile("input", "ab\ncd\nef\n");
    }

    protected void testProgram() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        Configuration ifConf = new Configuration();
        ifConf.setString("prepend", "test");
        DataSource ds = env.createInput((InputFormat)new TestInputFormat(new Path(this.inputPath))).withParameters(ifConf);
        List result = ds.collect();
        String expectedResult = "ab\ncd\nef\n";
        DataSourceITCase.compareResultAsText((List)result, (String)expectedResult);
    }

    private static class TestInputFormat
    extends TextInputFormat {
        private static final long serialVersionUID = 1L;

        public TestInputFormat(Path filePath) {
            super(filePath);
        }

        public void configure(Configuration parameters) {
            super.configure(parameters);
            Assert.assertNotNull((Object)parameters.getString("prepend", null));
            Assert.assertEquals((Object)"test", (Object)parameters.getString("prepend", null));
        }
    }
}

