/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.java.record.functions.MapFunction;
import org.apache.flink.api.java.record.functions.ReduceFunction;
import org.apache.flink.api.java.record.operators.BulkIteration;
import org.apache.flink.api.java.record.operators.FileDataSink;
import org.apache.flink.api.java.record.operators.FileDataSource;
import org.apache.flink.api.java.record.operators.MapOperator;
import org.apache.flink.api.java.record.operators.ReduceOperator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.test.recordJobs.kmeans.udfs.PointInFormat;
import org.apache.flink.test.recordJobs.kmeans.udfs.PointOutFormat;
import org.apache.flink.test.util.RecordAPITestBase;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.util.Collector;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IterationWithChainingITCase
extends RecordAPITestBase {
    private static final String DATA_POINTS = "0|50.90|16.20|72.08|\n1|73.65|61.76|62.89|\n2|61.73|49.95|92.74|\n";
    private String dataPath;
    private String resultPath;

    public IterationWithChainingITCase(Configuration config) {
        super(config);
        this.setTaskManagerNumSlots(4);
    }

    protected void preSubmit() throws Exception {
        this.dataPath = this.createTempFile("data_points.txt", DATA_POINTS);
        this.resultPath = this.getTempFilePath("result");
    }

    protected void postSubmit() throws Exception {
        IterationWithChainingITCase.compareResultsByLinesInMemory((String)DATA_POINTS, (String)this.resultPath);
    }

    protected Plan getTestJob() {
        return IterationWithChainingITCase.getTestPlan(this.config.getInteger("ChainedMapperITCase#NoSubtasks", 1), this.dataPath, this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() {
        Configuration config1 = new Configuration();
        config1.setInteger("ChainedMapperITCase#NoSubtasks", 4);
        return IterationWithChainingITCase.toParameterList((Configuration[])new Configuration[]{config1});
    }

    static Plan getTestPlan(int numSubTasks, String input, String output) {
        FileDataSource initialInput = new FileDataSource((FileInputFormat)new PointInFormat(), input, "Input");
        initialInput.setParallelism(1);
        BulkIteration iteration = new BulkIteration("Loop");
        iteration.setInput((Operator)initialInput);
        iteration.setMaximumNumberOfIterations(2);
        ReduceOperator dummyReduce = ReduceOperator.builder((ReduceFunction)new DummyReducer(), IntValue.class, (int)0).input(iteration.getPartialSolution()).name("Reduce something").build();
        MapOperator dummyMap = MapOperator.builder((MapFunction)new IdentityMapper()).input((Operator)dummyReduce).build();
        iteration.setNextPartialSolution((Operator)dummyMap);
        FileDataSink finalResult = new FileDataSink((FileOutputFormat)new PointOutFormat(), output, (Operator)iteration, "Output");
        Plan plan = new Plan((GenericDataSinkBase)finalResult, "Iteration with chained map test");
        plan.setDefaultParallelism(numSubTasks);
        return plan;
    }

    public static final class DummyReducer
    extends ReduceFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void reduce(Iterator<Record> it, Collector<Record> out) {
            while (it.hasNext()) {
                out.collect((Object)it.next());
            }
        }
    }

    public static final class IdentityMapper
    extends MapFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void map(Record rec, Collector<Record> out) {
            out.collect((Object)rec);
        }
    }
}

