/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.failingPrograms;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.client.JobSubmissionException;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmanager.Tasks;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.test.util.ForkableFlinkMiniCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JobSubmissionFailsITCase {
    private static final int NUM_SLOTS = 20;
    private static ForkableFlinkMiniCluster cluster;
    private static JobGraph workingJobGraph;
    private boolean detached;

    @BeforeClass
    public static void setup() {
        try {
            Configuration config = new Configuration();
            config.setInteger("taskmanager.memory.size", 4);
            config.setInteger("local.number-taskmanager", 2);
            config.setInteger("taskmanager.numberOfTaskSlots", 10);
            cluster = new ForkableFlinkMiniCluster(config);
            cluster.start();
            JobVertex jobVertex = new JobVertex("Working job vertex.");
            jobVertex.setInvokableClass(Tasks.NoOpInvokable.class);
            workingJobGraph = new JobGraph("Working testing job", new JobVertex[]{jobVertex});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @AfterClass
    public static void teardown() {
        try {
            cluster.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public JobSubmissionFailsITCase(boolean detached) {
        this.detached = detached;
    }

    @Parameterized.Parameters(name="Detached mode = {0}")
    public static Collection<Boolean[]> executionModes() {
        return Arrays.asList({false}, {true});
    }

    private JobExecutionResult submitJob(JobGraph jobGraph) throws Exception {
        if (this.detached) {
            cluster.submitJobDetached(jobGraph);
            return null;
        }
        return cluster.submitJobAndWait(jobGraph, false, TestingUtils.TESTING_DURATION());
    }

    @Test
    public void testExceptionInInitializeOnMaster() {
        try {
            FailingJobVertex failingJobVertex = new FailingJobVertex("Failing job vertex");
            failingJobVertex.setInvokableClass(Tasks.NoOpInvokable.class);
            JobGraph failingJobGraph = new JobGraph("Failing testing job", new JobVertex[]{failingJobVertex});
            try {
                this.submitJob(failingJobGraph);
                Assert.fail((String)"Expected JobExecutionException.");
            }
            catch (JobExecutionException e) {
                Assert.assertEquals((Object)"Test exception.", (Object)e.getCause().getMessage());
            }
            catch (Throwable t) {
                t.printStackTrace();
                Assert.fail((String)("Caught wrong exception of type " + t.getClass() + "."));
            }
            cluster.submitJobAndWait(workingJobGraph, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSubmitEmptyJobGraph() {
        try {
            JobGraph jobGraph = new JobGraph("Testing job");
            try {
                this.submitJob(jobGraph);
                Assert.fail((String)"Expected JobSubmissionException.");
            }
            catch (JobSubmissionException e) {
                Assert.assertTrue((e.getMessage() != null && e.getMessage().contains("empty") ? 1 : 0) != 0);
            }
            catch (Throwable t) {
                t.printStackTrace();
                Assert.fail((String)("Caught wrong exception of type " + t.getClass() + "."));
            }
            cluster.submitJobAndWait(workingJobGraph, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSubmitNullJobGraph() {
        try {
            try {
                this.submitJob(null);
                Assert.fail((String)"Expected JobSubmissionException.");
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Throwable t) {
                t.printStackTrace();
                Assert.fail((String)("Caught wrong exception of type " + t.getClass() + "."));
            }
            cluster.submitJobAndWait(workingJobGraph, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static class FailingJobVertex
    extends JobVertex {
        private static final long serialVersionUID = -6365291240199412135L;

        public FailingJobVertex(String msg) {
            super(msg);
        }

        public void initializeOnMaster(ClassLoader loader) throws Exception {
            throw new Exception("Test exception.");
        }
    }
}

