/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.checkpointing;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichFilterFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.functions.RichReduceFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.checkpoint.Checkpointed;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.co.CoFlatMapFunction;
import org.apache.flink.streaming.api.functions.co.RichCoFlatMapFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.source.ParallelSourceFunction;
import org.apache.flink.streaming.api.functions.source.RichSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.test.checkpointing.StreamFaultToleranceTestBase;
import org.apache.flink.util.Collector;
import org.junit.Assert;

public class CoStreamCheckpointingITCase
extends StreamFaultToleranceTestBase {
    final long NUM_STRINGS = 10000000L;

    @Override
    public void testProgram(StreamExecutionEnvironment env) {
        Assert.assertTrue((String)"Broken test setup", (boolean)true);
        DataStreamSource stream = env.addSource((SourceFunction)new StringGeneratingSourceFunction(10000000L));
        stream.filter((FilterFunction)new StringRichFilterFunction()).connect((DataStream)stream).flatMap((CoFlatMapFunction)new LeftIdentityCoRichFlatMapFunction()).map((MapFunction)new StringPrefixCountRichMapFunction()).startNewChain().map((MapFunction)new StatefulCounterFunction()).keyBy(new String[]{"prefix"}).reduce((ReduceFunction)new OnceFailingReducer(10000000L)).addSink((SinkFunction)new SinkFunction<StreamFaultToleranceTestBase.PrefixCount>(){

            public void invoke(StreamFaultToleranceTestBase.PrefixCount value) {
            }
        });
    }

    @Override
    public void postSubmit() {
        long filterSum = 0L;
        for (long l : StringRichFilterFunction.counts) {
            filterSum += l;
        }
        long coMapSum = 0L;
        for (long l : LeftIdentityCoRichFlatMapFunction.counts) {
            coMapSum += l;
        }
        long mapSum = 0L;
        for (long l : StringPrefixCountRichMapFunction.counts) {
            mapSum += l;
        }
        long countSum = 0L;
        for (long l : StatefulCounterFunction.counts) {
            countSum += l;
        }
        if (!StringPrefixCountRichMapFunction.restoreCalledAtLeastOnce) {
            System.err.println("Test inconclusive: Restore was never called on counting Map function.");
        }
        if (!LeftIdentityCoRichFlatMapFunction.restoreCalledAtLeastOnce) {
            System.err.println("Test inconclusive: Restore was never called on counting CoMap function.");
        }
        Assert.assertEquals((long)10000000L, (long)filterSum);
        Assert.assertEquals((long)10000000L, (long)coMapSum);
        Assert.assertEquals((long)10000000L, (long)mapSum);
        Assert.assertEquals((long)10000000L, (long)countSum);
    }

    private static class LeftIdentityCoRichFlatMapFunction
    extends RichCoFlatMapFunction<String, String, String>
    implements Checkpointed<Long> {
        static final long[] counts = new long[6];
        static volatile boolean restoreCalledAtLeastOnce = false;
        private long count;

        private LeftIdentityCoRichFlatMapFunction() {
        }

        public void flatMap1(String value, Collector<String> out) {
            ++this.count;
            out.collect((Object)value);
        }

        public void flatMap2(String value, Collector<String> out) {
        }

        public Long snapshotState(long checkpointId, long checkpointTimestamp) {
            return this.count;
        }

        public void restoreState(Long state) {
            restoreCalledAtLeastOnce = true;
            this.count = state;
        }

        public void close() throws IOException {
            LeftIdentityCoRichFlatMapFunction.counts[this.getRuntimeContext().getIndexOfThisSubtask()] = this.count;
        }
    }

    private static class StringPrefixCountRichMapFunction
    extends RichMapFunction<String, StreamFaultToleranceTestBase.PrefixCount>
    implements Checkpointed<Long> {
        static final long[] counts = new long[6];
        static volatile boolean restoreCalledAtLeastOnce = false;
        private long count;

        private StringPrefixCountRichMapFunction() {
        }

        public StreamFaultToleranceTestBase.PrefixCount map(String value) {
            ++this.count;
            return new StreamFaultToleranceTestBase.PrefixCount(value.substring(0, 1), value, 1L);
        }

        public Long snapshotState(long checkpointId, long checkpointTimestamp) {
            return this.count;
        }

        public void restoreState(Long state) {
            restoreCalledAtLeastOnce = true;
            this.count = state;
            if (this.count == 0L) {
                throw new RuntimeException("Restore from beginning");
            }
        }

        public void close() throws IOException {
            StringPrefixCountRichMapFunction.counts[this.getRuntimeContext().getIndexOfThisSubtask()] = this.count;
        }
    }

    private static class StringRichFilterFunction
    extends RichFilterFunction<String>
    implements Checkpointed<Long> {
        Long count = 0L;
        static final long[] counts = new long[6];

        private StringRichFilterFunction() {
        }

        public boolean filter(String value) {
            Long l = this.count;
            Long l2 = this.count = Long.valueOf(this.count + 1L);
            return value.length() < 100;
        }

        public void close() {
            StringRichFilterFunction.counts[this.getRuntimeContext().getIndexOfThisSubtask()] = this.count;
        }

        public Long snapshotState(long checkpointId, long checkpointTimestamp) throws Exception {
            return this.count;
        }

        public void restoreState(Long state) {
            this.count = state;
        }
    }

    private static class OnceFailingReducer
    extends RichReduceFunction<StreamFaultToleranceTestBase.PrefixCount> {
        private static volatile boolean hasFailed = false;
        private final long numElements;
        private long failurePos;
        private long count;

        OnceFailingReducer(long numElements) {
            this.numElements = numElements;
        }

        public void open(Configuration parameters) {
            long failurePosMin = (long)(0.4 * (double)this.numElements / (double)this.getRuntimeContext().getNumberOfParallelSubtasks());
            long failurePosMax = (long)(0.7 * (double)this.numElements / (double)this.getRuntimeContext().getNumberOfParallelSubtasks());
            this.failurePos = new Random().nextLong() % (failurePosMax - failurePosMin) + failurePosMin;
            this.count = 0L;
        }

        public StreamFaultToleranceTestBase.PrefixCount reduce(StreamFaultToleranceTestBase.PrefixCount value1, StreamFaultToleranceTestBase.PrefixCount value2) throws Exception {
            ++this.count;
            if (!hasFailed && this.count >= this.failurePos) {
                hasFailed = true;
                throw new Exception("Test Failure");
            }
            value1.count += value2.count;
            return value1;
        }
    }

    private static class StatefulCounterFunction
    extends RichMapFunction<StreamFaultToleranceTestBase.PrefixCount, StreamFaultToleranceTestBase.PrefixCount>
    implements Checkpointed<Long> {
        static final long[] counts = new long[6];
        private long count;

        private StatefulCounterFunction() {
        }

        public StreamFaultToleranceTestBase.PrefixCount map(StreamFaultToleranceTestBase.PrefixCount value) throws Exception {
            ++this.count;
            return value;
        }

        public void close() throws IOException {
            StatefulCounterFunction.counts[this.getRuntimeContext().getIndexOfThisSubtask()] = this.count;
        }

        public Long snapshotState(long checkpointId, long checkpointTimestamp) {
            return this.count;
        }

        public void restoreState(Long state) {
            this.count = state;
        }
    }

    private static class StringGeneratingSourceFunction
    extends RichSourceFunction<String>
    implements ParallelSourceFunction<String>,
    Checkpointed<Integer> {
        static final long[] counts = new long[6];
        private final long numElements;
        private Random rnd;
        private StringBuilder stringBuilder;
        private int index;
        private int step;
        private volatile boolean isRunning = true;

        StringGeneratingSourceFunction(long numElements) {
            this.numElements = numElements;
        }

        public void open(Configuration parameters) throws IOException {
            this.rnd = new Random();
            this.stringBuilder = new StringBuilder();
            this.step = this.getRuntimeContext().getNumberOfParallelSubtasks();
            if (this.index == 0) {
                this.index = this.getRuntimeContext().getIndexOfThisSubtask();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(SourceFunction.SourceContext<String> ctx) throws Exception {
            Object lockingObject = ctx.getCheckpointLock();
            while (this.isRunning && (long)this.index < this.numElements) {
                char first = (char)(this.index % 40 + 40);
                this.stringBuilder.setLength(0);
                this.stringBuilder.append(first);
                String result = StringGeneratingSourceFunction.randomString(this.stringBuilder, this.rnd);
                Object object = lockingObject;
                synchronized (object) {
                    this.index += this.step;
                    ctx.collect((Object)result);
                }
            }
        }

        public void close() throws IOException {
            StringGeneratingSourceFunction.counts[this.getRuntimeContext().getIndexOfThisSubtask()] = this.index;
        }

        public void cancel() {
            this.isRunning = false;
        }

        private static String randomString(StringBuilder bld, Random rnd) {
            int len = rnd.nextInt(10) + 5;
            for (int i = 0; i < len; ++i) {
                char next = (char)(rnd.nextInt(20000) + 33);
                bld.append(next);
            }
            return bld.toString();
        }

        public Integer snapshotState(long checkpointId, long checkpointTimestamp) {
            return this.index;
        }

        public void restoreState(Integer state) {
            this.index = state;
        }
    }
}

