/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.cancelling;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.java.record.functions.MapFunction;
import org.apache.flink.api.java.record.operators.GenericDataSink;
import org.apache.flink.api.java.record.operators.GenericDataSource;
import org.apache.flink.api.java.record.operators.MapOperator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.test.cancelling.CancellingTestBase;
import org.apache.flink.test.recordJobs.util.DiscardingOutputFormat;
import org.apache.flink.test.recordJobs.util.InfiniteIntegerInputFormat;
import org.apache.flink.types.Record;
import org.apache.flink.util.Collector;

public class MapCancelingITCase
extends CancellingTestBase {
    private static final int parallelism = 4;

    public MapCancelingITCase() {
        this.setTaskManagerNumSlots(4);
    }

    public void testMapCancelling() throws Exception {
        GenericDataSource source = new GenericDataSource((InputFormat)new InfiniteIntegerInputFormat(), "Source");
        MapOperator mapper = MapOperator.builder(IdentityMapper.class).input((Operator)source).name("Identity Mapper").build();
        GenericDataSink sink = new GenericDataSink((OutputFormat)new DiscardingOutputFormat(), (Operator)mapper, "Sink");
        Plan p = new Plan((GenericDataSinkBase)sink);
        p.setDefaultParallelism(4);
        this.runAndCancelJob(p, 5000, 10000);
    }

    public void testSlowMapCancelling() throws Exception {
        GenericDataSource source = new GenericDataSource((InputFormat)new InfiniteIntegerInputFormat(), "Source");
        MapOperator mapper = MapOperator.builder(DelayingIdentityMapper.class).input((Operator)source).name("Delay Mapper").build();
        GenericDataSink sink = new GenericDataSink((OutputFormat)new DiscardingOutputFormat(), (Operator)mapper, "Sink");
        Plan p = new Plan((GenericDataSinkBase)sink);
        p.setDefaultParallelism(4);
        this.runAndCancelJob(p, 5000, 10000);
    }

    public void testMapWithLongCancellingResponse() throws Exception {
        GenericDataSource source = new GenericDataSource((InputFormat)new InfiniteIntegerInputFormat(), "Source");
        MapOperator mapper = MapOperator.builder(LongCancelTimeIdentityMapper.class).input((Operator)source).name("Long Cancelling Time Mapper").build();
        GenericDataSink sink = new GenericDataSink((OutputFormat)new DiscardingOutputFormat(), (Operator)mapper, "Sink");
        Plan p = new Plan((GenericDataSinkBase)sink);
        p.setDefaultParallelism(4);
        this.runAndCancelJob(p, 10000, 10000);
    }

    public void testMapPriorToFirstRecordReading() throws Exception {
        GenericDataSource source = new GenericDataSource((InputFormat)new InfiniteIntegerInputFormat(), "Source");
        MapOperator mapper = MapOperator.builder(StuckInOpenIdentityMapper.class).input((Operator)source).name("Stuck-In-Open Mapper").build();
        GenericDataSink sink = new GenericDataSink((OutputFormat)new DiscardingOutputFormat(), (Operator)mapper, "Sink");
        Plan p = new Plan((GenericDataSinkBase)sink);
        p.setDefaultParallelism(4);
        this.runAndCancelJob(p, 10000, 10000);
    }

    public static final class StuckInOpenIdentityMapper
    extends MapFunction {
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void open(Configuration parameters) throws Exception {
            StuckInOpenIdentityMapper stuckInOpenIdentityMapper = this;
            synchronized (stuckInOpenIdentityMapper) {
                ((Object)((Object)this)).wait();
            }
        }

        public void map(Record record, Collector<Record> out) throws Exception {
            out.collect((Object)record);
        }
    }

    public static final class LongCancelTimeIdentityMapper
    extends MapFunction {
        private static final long serialVersionUID = 1L;
        private static final int WAIT_TIME_PER_RECORD = 5000;

        public void map(Record record, Collector<Record> out) throws Exception {
            long start = System.currentTimeMillis();
            long remaining = 5000L;
            do {
                try {
                    Thread.sleep(remaining);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while ((remaining = 5000L - System.currentTimeMillis() + start) > 0L);
            out.collect((Object)record);
        }
    }

    public static final class DelayingIdentityMapper
    extends MapFunction {
        private static final long serialVersionUID = 1L;
        private static final int WAIT_TIME_PER_RECORD = 10000;

        public void map(Record record, Collector<Record> out) throws Exception {
            Thread.sleep(10000L);
            out.collect((Object)record);
        }
    }

    public static final class IdentityMapper
    extends MapFunction {
        private static final long serialVersionUID = 1L;

        public void map(Record record, Collector<Record> out) throws Exception {
            out.collect((Object)record);
        }
    }
}

