/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.runtime;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.runtime.ScalaSpecialTypesSerializerTestInstance;
import org.apache.flink.api.scala.runtime.WeekDay$;
import org.apache.flink.api.scala.typeutils.EitherTypeInfo;
import org.apache.flink.api.scala.typeutils.EnumValueTypeInfo;
import org.apache.flink.api.scala.typeutils.OptionTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaNothingTypeInfo;
import org.apache.flink.api.scala.typeutils.TryTypeInfo;
import org.junit.Assert;
import org.junit.Test;
import scala.Enumeration;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0001\u0002\u0001\u001f\ty2kY1mCN\u0003XmY5bYRK\b/Z:TKJL\u0017\r\\5{KJ$Vm\u001d;\u000b\u0005\r!\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000b\u0019\tQa]2bY\u0006T!a\u0002\u0005\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0019R\"\u0001\n\u000b\u0003\u0015I!\u0001\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00151\u0002\u0001\"\u0001\u0018\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0004\u0005\u0002\u001a\u00015\t!\u0001C\u0003\u001c\u0001\u0011\u0005A$\u0001\u0006uKN$x\n\u001d;j_:$\u0012!\b\t\u0003#yI!a\b\n\u0003\tUs\u0017\u000e\u001e\u0015\u00035\u0005\u0002\"AI\u0013\u000e\u0003\rR!\u0001\n\u0007\u0002\u000b),h.\u001b;\n\u0005\u0019\u001a#\u0001\u0002+fgRDQ\u0001\u000b\u0001\u0005\u0002q\t\u0001\u0002^3tiN{W.\u001a\u0015\u0003O\u0005BQa\u000b\u0001\u0005\u0002q\t\u0001\u0002^3ti:{g.\u001a\u0015\u0003U\u0005BQA\f\u0001\u0005\u0002q\t!\u0002^3ti\u0016KG\u000f[3sQ\ti\u0013\u0005C\u00032\u0001\u0011\u0005A$\u0001\u0005uKN$H*\u001a4uQ\t\u0001\u0014\u0005C\u00035\u0001\u0011\u0005A$A\u0005uKN$(+[4ii\"\u00121'\t\u0005\u0006o\u0001!\t\u0001H\u0001\u000ei\u0016\u001cH/\u00128v[Z\u000bG.^3)\u0005Y\n\u0003\"\u0002\u001e\u0001\t\u0003a\u0012a\u0002;fgR$&/\u001f\u0015\u0003s\u0005BQ!\u0010\u0001\u0005\u0002q\t1\u0002^3tiN+8mY3tg\"\u0012A(\t\u0005\u0006\u0001\u0002!\t\u0001H\u0001\fi\u0016\u001cHOR1jYV\u0014X\r\u000b\u0002@C!)1\t\u0001C\u0007\t\u0006A!/\u001e8UKN$8/\u0006\u0002F'R\u0011a\t\u0018\u000b\u0003;\u001dCq\u0001\u0013\"\u0002\u0002\u0003\u000f\u0011*\u0001\u0006fm&$WM\\2fIE\u00022AS(R\u001b\u0005Y%B\u0001'N\u0003!!\u0018\u0010]3j]\u001a|'B\u0001(\u0007\u0003\u0019\u0019w.\\7p]&\u0011\u0001k\u0013\u0002\u0010)f\u0004X-\u00138g_Jl\u0017\r^5p]B\u0011!k\u0015\u0007\u0001\t\u0015!&I1\u0001V\u0005\u0005!\u0016C\u0001,Z!\t\tr+\u0003\u0002Y%\t9aj\u001c;iS:<\u0007CA\t[\u0013\tY&CA\u0002B]fDQ!\u0018\"A\u0002y\u000b\u0011\"\u001b8ti\u0006t7-Z:\u0011\u0007Ey\u0016+\u0003\u0002a%\t)\u0011I\u001d:bs\u0002")
public class ScalaSpecialTypesSerializerTest {
    @Test
    public void testOption() {
        Option[] testData = (Option[])((Object[])new Option[]{new Some((Object)"Hello"), new Some((Object)"Ciao"), None$.MODULE$});
        this.runTests(testData, (TypeInformation)new OptionTypeInfo((TypeInformation)BasicTypeInfo.getInfoFor(String.class)));
    }

    @Test
    public void testSome() {
        Some[] testData = (Some[])((Object[])new Some[]{new Some((Object)"Hello"), new Some((Object)"Ciao")});
        this.runTests(testData, (TypeInformation)new OptionTypeInfo((TypeInformation)BasicTypeInfo.getInfoFor(String.class)));
    }

    @Test
    public void testNone() {
        None$[] testData = (None$[])((Object[])new None$[]{None$.MODULE$, None$.MODULE$});
        this.runTests(testData, (TypeInformation)new OptionTypeInfo((TypeInformation)new ScalaNothingTypeInfo()));
    }

    @Test
    public void testEither() {
        Either[] testData = (Either[])((Object[])new Either[]{package$.MODULE$.Left().apply((Object)"Hell"), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)3))});
        this.runTests(testData, (TypeInformation)new EitherTypeInfo(Either.class, (TypeInformation)BasicTypeInfo.getInfoFor(String.class), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)));
    }

    @Test
    public void testLeft() {
        Left[] testData = (Left[])((Object[])new Left[]{package$.MODULE$.Left().apply((Object)"Hell"), package$.MODULE$.Left().apply((Object)"CIao")});
        this.runTests(testData, (TypeInformation)new EitherTypeInfo(Left.class, (TypeInformation)BasicTypeInfo.getInfoFor(String.class), (TypeInformation)new ScalaNothingTypeInfo()));
    }

    @Test
    public void testRight() {
        Right[] testData = (Right[])((Object[])new Right[]{package$.MODULE$.Right().apply((Object)"Hell"), package$.MODULE$.Right().apply((Object)"CIao")});
        this.runTests(testData, (TypeInformation)new EitherTypeInfo(Right.class, (TypeInformation)new ScalaNothingTypeInfo(), (TypeInformation)BasicTypeInfo.getInfoFor(String.class)));
    }

    @Test
    public void testEnumValue() {
        Enumeration.Value[] testData = (Enumeration.Value[])((Object[])new Enumeration.Value[]{WeekDay$.MODULE$.Mon(), WeekDay$.MODULE$.Fri(), WeekDay$.MODULE$.Tue(), WeekDay$.MODULE$.Sun(), WeekDay$.MODULE$.Wed()});
        this.runTests(testData, (TypeInformation)new EnumValueTypeInfo((Enumeration)WeekDay$.MODULE$, Enumeration.Value.class));
    }

    @Test
    public void testTry() {
        Try[] testData = (Try[])((Object[])new Try[]{new Success((Object)"Hell"), new Failure((Throwable)new RuntimeException("test"))});
        this.runTests(testData, (TypeInformation)new TryTypeInfo((TypeInformation)BasicTypeInfo.getInfoFor(String.class)));
    }

    @Test
    public void testSuccess() {
        Success[] testData = (Success[])((Object[])new Success[]{new Success((Object)"Hell"), new Success((Object)"Yeah")});
        this.runTests(testData, (TypeInformation)new TryTypeInfo((TypeInformation)BasicTypeInfo.getInfoFor(String.class)));
    }

    @Test
    public void testFailure() {
        Failure[] testData = (Failure[])((Object[])new Failure[]{new Failure((Throwable)new RuntimeException("test")), new Failure((Throwable)new RuntimeException("one, two"))});
        this.runTests(testData, (TypeInformation)new TryTypeInfo((TypeInformation)new ScalaNothingTypeInfo()));
    }

    private final <T> void runTests(Object instances, TypeInformation<T> evidence$1) {
        try {
            TypeInformation typeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$1);
            TypeSerializer serializer = typeInfo.createSerializer(new ExecutionConfig());
            Class typeClass = typeInfo.getTypeClass();
            ScalaSpecialTypesSerializerTestInstance test = new ScalaSpecialTypesSerializerTestInstance(serializer, typeClass, serializer.getLength(), instances);
            test.testAll();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            Assert.fail((String)exception.getMessage());
        }
    }
}

